/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutFunctionConcurrencyRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, PutFunctionConcurrencyRequest> {
    private final String functionName;
    private final Integer reservedConcurrentExecutions;

    private PutFunctionConcurrencyRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.reservedConcurrentExecutions = builder.reservedConcurrentExecutions;
    }

    public String functionName() {
        return this.functionName;
    }

    public Integer reservedConcurrentExecutions() {
        return this.reservedConcurrentExecutions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedConcurrentExecutions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFunctionConcurrencyRequest)) {
            return false;
        }
        PutFunctionConcurrencyRequest other = (PutFunctionConcurrencyRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.reservedConcurrentExecutions(), other.reservedConcurrentExecutions());
    }

    public String toString() {
        return ToString.builder((String)"PutFunctionConcurrencyRequest").add("FunctionName", (Object)this.functionName()).add("ReservedConcurrentExecutions", (Object)this.reservedConcurrentExecutions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.of(clazz.cast(this.functionName()));
            }
            case "ReservedConcurrentExecutions": {
                return Optional.of(clazz.cast(this.reservedConcurrentExecutions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private Integer reservedConcurrentExecutions;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFunctionConcurrencyRequest model) {
            this.functionName(model.functionName);
            this.reservedConcurrentExecutions(model.reservedConcurrentExecutions);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final Integer getReservedConcurrentExecutions() {
            return this.reservedConcurrentExecutions;
        }

        @Override
        public final Builder reservedConcurrentExecutions(Integer reservedConcurrentExecutions) {
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
            return this;
        }

        public final void setReservedConcurrentExecutions(Integer reservedConcurrentExecutions) {
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutFunctionConcurrencyRequest build() {
            return new PutFunctionConcurrencyRequest(this);
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    CopyableBuilder<Builder, PutFunctionConcurrencyRequest> {
        public Builder functionName(String var1);

        public Builder reservedConcurrentExecutions(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

