/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.lambda.transform.FunctionCodeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FunctionCode
implements StructuredPojo,
ToCopyableBuilder<Builder, FunctionCode> {
    private final ByteBuffer zipFile;
    private final String s3Bucket;
    private final String s3Key;
    private final String s3ObjectVersion;

    private FunctionCode(BuilderImpl builder) {
        this.zipFile = builder.zipFile;
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
        this.s3ObjectVersion = builder.s3ObjectVersion;
    }

    public ByteBuffer zipFile() {
        return this.zipFile == null ? null : this.zipFile.asReadOnlyBuffer();
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String s3Key() {
        return this.s3Key;
    }

    public String s3ObjectVersion() {
        return this.s3ObjectVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.zipFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ObjectVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionCode)) {
            return false;
        }
        FunctionCode other = (FunctionCode)obj;
        return Objects.equals(this.zipFile(), other.zipFile()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3Key(), other.s3Key()) && Objects.equals(this.s3ObjectVersion(), other.s3ObjectVersion());
    }

    public String toString() {
        return ToString.builder((String)"FunctionCode").add("ZipFile", (Object)this.zipFile()).add("S3Bucket", (Object)this.s3Bucket()).add("S3Key", (Object)this.s3Key()).add("S3ObjectVersion", (Object)this.s3ObjectVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ZipFile": {
                return Optional.of(clazz.cast(this.zipFile()));
            }
            case "S3Bucket": {
                return Optional.of(clazz.cast(this.s3Bucket()));
            }
            case "S3Key": {
                return Optional.of(clazz.cast(this.s3Key()));
            }
            case "S3ObjectVersion": {
                return Optional.of(clazz.cast(this.s3ObjectVersion()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FunctionCodeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ByteBuffer zipFile;
        private String s3Bucket;
        private String s3Key;
        private String s3ObjectVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionCode model) {
            this.zipFile(model.zipFile);
            this.s3Bucket(model.s3Bucket);
            this.s3Key(model.s3Key);
            this.s3ObjectVersion(model.s3ObjectVersion);
        }

        public final ByteBuffer getZipFile() {
            return this.zipFile;
        }

        @Override
        public final Builder zipFile(ByteBuffer zipFile) {
            this.zipFile = StandardMemberCopier.copy((ByteBuffer)zipFile);
            return this;
        }

        public final void setZipFile(ByteBuffer zipFile) {
            this.zipFile = StandardMemberCopier.copy((ByteBuffer)zipFile);
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        public final String getS3ObjectVersion() {
            return this.s3ObjectVersion;
        }

        @Override
        public final Builder s3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
            return this;
        }

        public final void setS3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
        }

        public FunctionCode build() {
            return new FunctionCode(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FunctionCode> {
        public Builder zipFile(ByteBuffer var1);

        public Builder s3Bucket(String var1);

        public Builder s3Key(String var1);

        public Builder s3ObjectVersion(String var1);
    }
}

