/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.GetFunctionRequest;

@SdkInternalApi
public class GetFunctionRequestModelMarshaller {
    private static final MarshallingInfo<String> FUNCTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("FunctionName").build();
    private static final MarshallingInfo<String> QUALIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("Qualifier").build();
    private static final GetFunctionRequestModelMarshaller INSTANCE = new GetFunctionRequestModelMarshaller();

    public static GetFunctionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetFunctionRequest getFunctionRequest, ProtocolMarshaller protocolMarshaller) {
        if (getFunctionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)getFunctionRequest.functionName(), FUNCTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)getFunctionRequest.qualifier(), QUALIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

