/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.FunctionCodeLocation;

@SdkInternalApi
public class FunctionCodeLocationMarshaller {
    private static final MarshallingInfo<String> REPOSITORYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RepositoryType").build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Location").build();
    private static final FunctionCodeLocationMarshaller INSTANCE = new FunctionCodeLocationMarshaller();

    public static FunctionCodeLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FunctionCodeLocation functionCodeLocation, ProtocolMarshaller protocolMarshaller) {
        if (functionCodeLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)functionCodeLocation.repositoryType(), REPOSITORYTYPE_BINDING);
            protocolMarshaller.marshall((Object)functionCodeLocation.location(), LOCATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

