/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lambda.model.AccountLimit;

public class AccountLimitUnmarshaller
implements Unmarshaller<AccountLimit, JsonUnmarshallerContext> {
    private static final AccountLimitUnmarshaller INSTANCE = new AccountLimitUnmarshaller();

    public AccountLimit unmarshall(JsonUnmarshallerContext context) throws Exception {
        AccountLimit.Builder accountLimitBuilder = AccountLimit.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("TotalCodeSize", targetDepth)) {
                    context.nextToken();
                    accountLimitBuilder.totalCodeSize((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("CodeSizeUnzipped", targetDepth)) {
                    context.nextToken();
                    accountLimitBuilder.codeSizeUnzipped((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("CodeSizeZipped", targetDepth)) {
                    context.nextToken();
                    accountLimitBuilder.codeSizeZipped((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("ConcurrentExecutions", targetDepth)) {
                    context.nextToken();
                    accountLimitBuilder.concurrentExecutions((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AccountLimit)accountLimitBuilder.build();
    }

    public static AccountLimitUnmarshaller getInstance() {
        return INSTANCE;
    }
}

