/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.AccountLimit;

@SdkInternalApi
public class AccountLimitMarshaller {
    private static final MarshallingInfo<Long> TOTALCODESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalCodeSize").build();
    private static final MarshallingInfo<Long> CODESIZEUNZIPPED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeSizeUnzipped").build();
    private static final MarshallingInfo<Long> CODESIZEZIPPED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeSizeZipped").build();
    private static final MarshallingInfo<Integer> CONCURRENTEXECUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConcurrentExecutions").build();
    private static final AccountLimitMarshaller INSTANCE = new AccountLimitMarshaller();

    public static AccountLimitMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AccountLimit accountLimit, ProtocolMarshaller protocolMarshaller) {
        if (accountLimit == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)accountLimit.totalCodeSize(), TOTALCODESIZE_BINDING);
            protocolMarshaller.marshall((Object)accountLimit.codeSizeUnzipped(), CODESIZEUNZIPPED_BINDING);
            protocolMarshaller.marshall((Object)accountLimit.codeSizeZipped(), CODESIZEZIPPED_BINDING);
            protocolMarshaller.marshall((Object)accountLimit.concurrentExecutions(), CONCURRENTEXECUTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

