/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.StreamingRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.model.AddPermissionRequest;
import software.amazon.awssdk.services.lambda.model.AddPermissionResponse;
import software.amazon.awssdk.services.lambda.model.CodeStorageExceededException;
import software.amazon.awssdk.services.lambda.model.CreateAliasRequest;
import software.amazon.awssdk.services.lambda.model.CreateAliasResponse;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.CreateFunctionRequest;
import software.amazon.awssdk.services.lambda.model.CreateFunctionResponse;
import software.amazon.awssdk.services.lambda.model.DeleteAliasRequest;
import software.amazon.awssdk.services.lambda.model.DeleteAliasResponse;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.lambda.model.EC2AccessDeniedException;
import software.amazon.awssdk.services.lambda.model.EC2ThrottledException;
import software.amazon.awssdk.services.lambda.model.EC2UnexpectedException;
import software.amazon.awssdk.services.lambda.model.ENILimitReachedException;
import software.amazon.awssdk.services.lambda.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.lambda.model.GetAliasRequest;
import software.amazon.awssdk.services.lambda.model.GetAliasResponse;
import software.amazon.awssdk.services.lambda.model.GetEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.GetEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionResponse;
import software.amazon.awssdk.services.lambda.model.GetPolicyRequest;
import software.amazon.awssdk.services.lambda.model.GetPolicyResponse;
import software.amazon.awssdk.services.lambda.model.InvalidParameterValueException;
import software.amazon.awssdk.services.lambda.model.InvalidRequestContentException;
import software.amazon.awssdk.services.lambda.model.InvalidRuntimeException;
import software.amazon.awssdk.services.lambda.model.InvalidSecurityGroupIDException;
import software.amazon.awssdk.services.lambda.model.InvalidSubnetIDException;
import software.amazon.awssdk.services.lambda.model.InvalidZipFileException;
import software.amazon.awssdk.services.lambda.model.InvokeAsyncRequest;
import software.amazon.awssdk.services.lambda.model.InvokeAsyncResponse;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.KMSAccessDeniedException;
import software.amazon.awssdk.services.lambda.model.KMSDisabledException;
import software.amazon.awssdk.services.lambda.model.KMSInvalidStateException;
import software.amazon.awssdk.services.lambda.model.KMSNotFoundException;
import software.amazon.awssdk.services.lambda.model.LambdaException;
import software.amazon.awssdk.services.lambda.model.ListAliasesRequest;
import software.amazon.awssdk.services.lambda.model.ListAliasesResponse;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsResponse;
import software.amazon.awssdk.services.lambda.model.ListTagsRequest;
import software.amazon.awssdk.services.lambda.model.ListTagsResponse;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse;
import software.amazon.awssdk.services.lambda.model.PolicyLengthExceededException;
import software.amazon.awssdk.services.lambda.model.PublishVersionRequest;
import software.amazon.awssdk.services.lambda.model.PublishVersionResponse;
import software.amazon.awssdk.services.lambda.model.RemovePermissionRequest;
import software.amazon.awssdk.services.lambda.model.RemovePermissionResponse;
import software.amazon.awssdk.services.lambda.model.RequestTooLargeException;
import software.amazon.awssdk.services.lambda.model.ResourceConflictException;
import software.amazon.awssdk.services.lambda.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lambda.model.ServiceException;
import software.amazon.awssdk.services.lambda.model.SubnetIPAddressLimitReachedException;
import software.amazon.awssdk.services.lambda.model.TagResourceRequest;
import software.amazon.awssdk.services.lambda.model.TagResourceResponse;
import software.amazon.awssdk.services.lambda.model.TooManyRequestsException;
import software.amazon.awssdk.services.lambda.model.UnsupportedMediaTypeException;
import software.amazon.awssdk.services.lambda.model.UntagResourceRequest;
import software.amazon.awssdk.services.lambda.model.UntagResourceResponse;
import software.amazon.awssdk.services.lambda.model.UpdateAliasRequest;
import software.amazon.awssdk.services.lambda.model.UpdateAliasResponse;
import software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPaginator;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionsPaginator;
import software.amazon.awssdk.services.lambda.transform.AddPermissionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.AddPermissionResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.CreateAliasResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.CreateEventSourceMappingRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.CreateEventSourceMappingResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.CreateFunctionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.CreateFunctionResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteAliasRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteAliasResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteEventSourceMappingRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteEventSourceMappingResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteFunctionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteFunctionResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.GetAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetAccountSettingsResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.GetAliasRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetAliasResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.GetEventSourceMappingRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetEventSourceMappingResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.GetFunctionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetFunctionConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.GetFunctionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetFunctionResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.GetPolicyRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.InvokeAsyncRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.InvokeAsyncResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.InvokeRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.InvokeResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListAliasesResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.ListEventSourceMappingsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListEventSourceMappingsResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.ListFunctionsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListFunctionsResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListTagsResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.ListVersionsByFunctionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListVersionsByFunctionResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.PublishVersionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.PublishVersionResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.RemovePermissionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.RemovePermissionResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.TagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UntagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateAliasRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateAliasResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateEventSourceMappingRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateEventSourceMappingResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateFunctionCodeRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateFunctionCodeResponseUnmarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateFunctionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateFunctionConfigurationResponseUnmarshaller;

@SdkInternalApi
final class DefaultLambdaClient
implements LambdaClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final ClientConfiguration clientConfiguration;

    protected DefaultLambdaClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public AddPermissionResponse addPermission(AddPermissionRequest addPermissionRequest) throws ServiceException, ResourceNotFoundException, ResourceConflictException, InvalidParameterValueException, PolicyLengthExceededException, TooManyRequestsException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddPermissionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AddPermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addPermissionRequest).withMarshaller((Marshaller)new AddPermissionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws ServiceException, ResourceNotFoundException, ResourceConflictException, InvalidParameterValueException, TooManyRequestsException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAliasResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAliasRequest).withMarshaller((Marshaller)new CreateAliasRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateEventSourceMappingResponse createEventSourceMapping(CreateEventSourceMappingRequest createEventSourceMappingRequest) throws ServiceException, InvalidParameterValueException, ResourceConflictException, TooManyRequestsException, ResourceNotFoundException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateEventSourceMappingResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateEventSourceMappingResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEventSourceMappingRequest).withMarshaller((Marshaller)new CreateEventSourceMappingRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateFunctionResponse createFunction(CreateFunctionRequest createFunctionRequest) throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, ResourceConflictException, TooManyRequestsException, CodeStorageExceededException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateFunctionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFunctionRequest).withMarshaller((Marshaller)new CreateFunctionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteAliasResponse deleteAlias(DeleteAliasRequest deleteAliasRequest) throws ServiceException, InvalidParameterValueException, TooManyRequestsException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAliasResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAliasRequest).withMarshaller((Marshaller)new DeleteAliasRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteEventSourceMappingResponse deleteEventSourceMapping(DeleteEventSourceMappingRequest deleteEventSourceMappingRequest) throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEventSourceMappingResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteEventSourceMappingResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEventSourceMappingRequest).withMarshaller((Marshaller)new DeleteEventSourceMappingRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteFunctionResponse deleteFunction(DeleteFunctionRequest deleteFunctionRequest) throws ServiceException, ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, ResourceConflictException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteFunctionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFunctionRequest).withMarshaller((Marshaller)new DeleteFunctionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetAccountSettingsResponse getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest) throws TooManyRequestsException, ServiceException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAccountSettingsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetAccountSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAccountSettingsRequest).withMarshaller((Marshaller)new GetAccountSettingsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetAliasResponse getAlias(GetAliasRequest getAliasRequest) throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAliasResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAliasRequest).withMarshaller((Marshaller)new GetAliasRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetEventSourceMappingResponse getEventSourceMapping(GetEventSourceMappingRequest getEventSourceMappingRequest) throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEventSourceMappingResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetEventSourceMappingResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEventSourceMappingRequest).withMarshaller((Marshaller)new GetEventSourceMappingRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetFunctionResponse getFunction(GetFunctionRequest getFunctionRequest) throws ServiceException, ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFunctionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFunctionRequest).withMarshaller((Marshaller)new GetFunctionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetFunctionConfigurationResponse getFunctionConfiguration(GetFunctionConfigurationRequest getFunctionConfigurationRequest) throws ServiceException, ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFunctionConfigurationResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetFunctionConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFunctionConfigurationRequest).withMarshaller((Marshaller)new GetFunctionConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetPolicyResponse getPolicy(GetPolicyRequest getPolicyRequest) throws ServiceException, ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPolicyResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPolicyRequest).withMarshaller((Marshaller)new GetPolicyRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public InvokeResponse invoke(InvokeRequest invokeRequest) throws ServiceException, ResourceNotFoundException, InvalidRequestContentException, RequestTooLargeException, UnsupportedMediaTypeException, TooManyRequestsException, InvalidParameterValueException, EC2UnexpectedException, SubnetIPAddressLimitReachedException, ENILimitReachedException, EC2ThrottledException, EC2AccessDeniedException, InvalidSubnetIDException, InvalidSecurityGroupIDException, InvalidZipFileException, KMSDisabledException, KMSInvalidStateException, KMSAccessDeniedException, KMSNotFoundException, InvalidRuntimeException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(false), (Unmarshaller)new InvokeResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (InvokeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)invokeRequest).withMarshaller((Marshaller)new InvokeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public InvokeAsyncResponse invokeAsync(InvokeAsyncRequest invokeAsyncRequest, RequestBody requestBody) throws ServiceException, ResourceNotFoundException, InvalidRequestContentException, InvalidRuntimeException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InvokeAsyncResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (InvokeAsyncResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)invokeAsyncRequest).withMarshaller((Marshaller)new StreamingRequestMarshaller((Marshaller)new InvokeAsyncRequestMarshaller(this.protocolFactory), requestBody)));
    }

    @Override
    public ListAliasesResponse listAliases(ListAliasesRequest listAliasesRequest) throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAliasesResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListAliasesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAliasesRequest).withMarshaller((Marshaller)new ListAliasesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListEventSourceMappingsResponse listEventSourceMappings(ListEventSourceMappingsRequest listEventSourceMappingsRequest) throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEventSourceMappingsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListEventSourceMappingsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEventSourceMappingsRequest).withMarshaller((Marshaller)new ListEventSourceMappingsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListEventSourceMappingsPaginator listEventSourceMappingsIterable(ListEventSourceMappingsRequest listEventSourceMappingsRequest) throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, SdkServiceException, SdkClientException, LambdaException {
        return new ListEventSourceMappingsPaginator(this, listEventSourceMappingsRequest);
    }

    @Override
    public ListFunctionsResponse listFunctions(ListFunctionsRequest listFunctionsRequest) throws ServiceException, TooManyRequestsException, InvalidParameterValueException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFunctionsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListFunctionsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFunctionsRequest).withMarshaller((Marshaller)new ListFunctionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListFunctionsPaginator listFunctionsIterable(ListFunctionsRequest listFunctionsRequest) throws ServiceException, TooManyRequestsException, InvalidParameterValueException, SdkServiceException, SdkClientException, LambdaException {
        return new ListFunctionsPaginator(this, listFunctionsRequest);
    }

    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsRequest).withMarshaller((Marshaller)new ListTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListVersionsByFunctionResponse listVersionsByFunction(ListVersionsByFunctionRequest listVersionsByFunctionRequest) throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListVersionsByFunctionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListVersionsByFunctionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listVersionsByFunctionRequest).withMarshaller((Marshaller)new ListVersionsByFunctionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PublishVersionResponse publishVersion(PublishVersionRequest publishVersionRequest) throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, CodeStorageExceededException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PublishVersionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (PublishVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)publishVersionRequest).withMarshaller((Marshaller)new PublishVersionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RemovePermissionResponse removePermission(RemovePermissionRequest removePermissionRequest) throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemovePermissionResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RemovePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removePermissionRequest).withMarshaller((Marshaller)new RemovePermissionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateAliasResponse updateAlias(UpdateAliasRequest updateAliasRequest) throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAliasResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAliasRequest).withMarshaller((Marshaller)new UpdateAliasRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateEventSourceMappingResponse updateEventSourceMapping(UpdateEventSourceMappingRequest updateEventSourceMappingRequest) throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEventSourceMappingResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateEventSourceMappingResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEventSourceMappingRequest).withMarshaller((Marshaller)new UpdateEventSourceMappingRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateFunctionCodeResponse updateFunctionCode(UpdateFunctionCodeRequest updateFunctionCodeRequest) throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, CodeStorageExceededException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateFunctionCodeResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateFunctionCodeResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFunctionCodeRequest).withMarshaller((Marshaller)new UpdateFunctionCodeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateFunctionConfigurationResponse updateFunctionConfiguration(UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest) throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException, SdkServiceException, SdkClientException, LambdaException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateFunctionConfigurationResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateFunctionConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFunctionConfigurationRequest).withMarshaller((Marshaller)new UpdateFunctionConfigurationRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<SdkServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(LambdaException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterValueException").withModeledClass(InvalidParameterValueException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EC2AccessDeniedException").withModeledClass(EC2AccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicyLengthExceededException").withModeledClass(PolicyLengthExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSAccessDeniedException").withModeledClass(KMSAccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceException").withModeledClass(ServiceException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EC2ThrottledException").withModeledClass(EC2ThrottledException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSInvalidStateException").withModeledClass(KMSInvalidStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidZipFileException").withModeledClass(InvalidZipFileException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSDisabledException").withModeledClass(KMSDisabledException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestContentException").withModeledClass(InvalidRequestContentException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRuntimeException").withModeledClass(InvalidRuntimeException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EC2UnexpectedException").withModeledClass(EC2UnexpectedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSecurityGroupIDException").withModeledClass(InvalidSecurityGroupIDException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceConflictException").withModeledClass(ResourceConflictException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CodeStorageExceededException").withModeledClass(CodeStorageExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ENILimitReachedException").withModeledClass(ENILimitReachedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetIPAddressLimitReachedException").withModeledClass(SubnetIPAddressLimitReachedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("KMSNotFoundException").withModeledClass(KMSNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSubnetIDException").withModeledClass(InvalidSubnetIDException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RequestTooLargeException").withModeledClass(RequestTooLargeException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedMediaTypeException").withModeledClass(UnsupportedMediaTypeException.class)));
    }

    public void close() {
        this.clientHandler.close();
    }
}

