/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.ListFunctionsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsResponse;

public final class ListFunctionsPaginator
implements SdkIterable<ListFunctionsResponse> {
    private final LambdaClient client;
    private final ListFunctionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListFunctionsPaginator(LambdaClient client, ListFunctionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFunctionsResponseFetcher();
    }

    public Iterator<ListFunctionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<FunctionConfiguration> functions() {
        Function<ListFunctionsResponse, Iterator> getIterator = response -> response != null ? response.functions().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListFunctionsResponseFetcher
    implements NextPageFetcher<ListFunctionsResponse> {
        private ListFunctionsResponseFetcher() {
        }

        public boolean hasNextPage(ListFunctionsResponse previousPage) {
            return previousPage.nextMarker() != null;
        }

        public ListFunctionsResponse nextPage(ListFunctionsResponse previousPage) {
            if (previousPage == null) {
                return ListFunctionsPaginator.this.client.listFunctions(ListFunctionsPaginator.this.firstRequest);
            }
            return ListFunctionsPaginator.this.client.listFunctions((ListFunctionsRequest)((Object)ListFunctionsPaginator.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

