/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse;

public final class ListEventSourceMappingsPaginator
implements SdkIterable<ListEventSourceMappingsResponse> {
    private final LambdaClient client;
    private final ListEventSourceMappingsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListEventSourceMappingsPaginator(LambdaClient client, ListEventSourceMappingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEventSourceMappingsResponseFetcher();
    }

    public Iterator<ListEventSourceMappingsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<EventSourceMappingConfiguration> eventSourceMappings() {
        Function<ListEventSourceMappingsResponse, Iterator> getIterator = response -> response != null ? response.eventSourceMappings().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListEventSourceMappingsResponseFetcher
    implements NextPageFetcher<ListEventSourceMappingsResponse> {
        private ListEventSourceMappingsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventSourceMappingsResponse previousPage) {
            return previousPage.nextMarker() != null;
        }

        public ListEventSourceMappingsResponse nextPage(ListEventSourceMappingsResponse previousPage) {
            if (previousPage == null) {
                return ListEventSourceMappingsPaginator.this.client.listEventSourceMappings(ListEventSourceMappingsPaginator.this.firstRequest);
            }
            return ListEventSourceMappingsPaginator.this.client.listEventSourceMappings((ListEventSourceMappingsRequest)((Object)ListEventSourceMappingsPaginator.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

