/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.lambda.model.DeadLetterConfig;
import software.amazon.awssdk.services.lambda.model.Environment;
import software.amazon.awssdk.services.lambda.model.Runtime;
import software.amazon.awssdk.services.lambda.model.TracingConfig;
import software.amazon.awssdk.services.lambda.model.VpcConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateFunctionConfigurationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateFunctionConfigurationRequest> {
    private final String functionName;
    private final String role;
    private final String handler;
    private final String description;
    private final Integer timeout;
    private final Integer memorySize;
    private final VpcConfig vpcConfig;
    private final Environment environment;
    private final String runtime;
    private final DeadLetterConfig deadLetterConfig;
    private final String kmsKeyArn;
    private final TracingConfig tracingConfig;

    private UpdateFunctionConfigurationRequest(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.role = builder.role;
        this.handler = builder.handler;
        this.description = builder.description;
        this.timeout = builder.timeout;
        this.memorySize = builder.memorySize;
        this.vpcConfig = builder.vpcConfig;
        this.environment = builder.environment;
        this.runtime = builder.runtime;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tracingConfig = builder.tracingConfig;
    }

    public String functionName() {
        return this.functionName;
    }

    public String role() {
        return this.role;
    }

    public String handler() {
        return this.handler;
    }

    public String description() {
        return this.description;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public Integer memorySize() {
        return this.memorySize;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Environment environment() {
        return this.environment;
    }

    public Runtime runtime() {
        return Runtime.fromValue(this.runtime);
    }

    public String runtimeString() {
        return this.runtime;
    }

    public DeadLetterConfig deadLetterConfig() {
        return this.deadLetterConfig;
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public TracingConfig tracingConfig() {
        return this.tracingConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.handler());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracingConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionConfigurationRequest)) {
            return false;
        }
        UpdateFunctionConfigurationRequest other = (UpdateFunctionConfigurationRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.handler(), other.handler()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.memorySize(), other.memorySize()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.runtimeString(), other.runtimeString()) && Objects.equals(this.deadLetterConfig(), other.deadLetterConfig()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.tracingConfig(), other.tracingConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.functionName() != null) {
            sb.append("FunctionName: ").append(this.functionName()).append(",");
        }
        if (this.role() != null) {
            sb.append("Role: ").append(this.role()).append(",");
        }
        if (this.handler() != null) {
            sb.append("Handler: ").append(this.handler()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.timeout() != null) {
            sb.append("Timeout: ").append(this.timeout()).append(",");
        }
        if (this.memorySize() != null) {
            sb.append("MemorySize: ").append(this.memorySize()).append(",");
        }
        if (this.vpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.vpcConfig()).append(",");
        }
        if (this.environment() != null) {
            sb.append("Environment: ").append(this.environment()).append(",");
        }
        if (this.runtimeString() != null) {
            sb.append("Runtime: ").append(this.runtimeString()).append(",");
        }
        if (this.deadLetterConfig() != null) {
            sb.append("DeadLetterConfig: ").append(this.deadLetterConfig()).append(",");
        }
        if (this.kmsKeyArn() != null) {
            sb.append("KMSKeyArn: ").append(this.kmsKeyArn()).append(",");
        }
        if (this.tracingConfig() != null) {
            sb.append("TracingConfig: ").append(this.tracingConfig()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.of(clazz.cast(this.functionName()));
            }
            case "Role": {
                return Optional.of(clazz.cast(this.role()));
            }
            case "Handler": {
                return Optional.of(clazz.cast(this.handler()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Timeout": {
                return Optional.of(clazz.cast(this.timeout()));
            }
            case "MemorySize": {
                return Optional.of(clazz.cast(this.memorySize()));
            }
            case "VpcConfig": {
                return Optional.of(clazz.cast(this.vpcConfig()));
            }
            case "Environment": {
                return Optional.of(clazz.cast(this.environment()));
            }
            case "Runtime": {
                return Optional.of(clazz.cast(this.runtimeString()));
            }
            case "DeadLetterConfig": {
                return Optional.of(clazz.cast(this.deadLetterConfig()));
            }
            case "KMSKeyArn": {
                return Optional.of(clazz.cast(this.kmsKeyArn()));
            }
            case "TracingConfig": {
                return Optional.of(clazz.cast(this.tracingConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String functionName;
        private String role;
        private String handler;
        private String description;
        private Integer timeout;
        private Integer memorySize;
        private VpcConfig vpcConfig;
        private Environment environment;
        private String runtime;
        private DeadLetterConfig deadLetterConfig;
        private String kmsKeyArn;
        private TracingConfig tracingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionConfigurationRequest model) {
            this.functionName(model.functionName);
            this.role(model.role);
            this.handler(model.handler);
            this.description(model.description);
            this.timeout(model.timeout);
            this.memorySize(model.memorySize);
            this.vpcConfig(model.vpcConfig);
            this.environment(model.environment);
            this.runtime(model.runtime);
            this.deadLetterConfig(model.deadLetterConfig);
            this.kmsKeyArn(model.kmsKeyArn);
            this.tracingConfig(model.tracingConfig);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getHandler() {
            return this.handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Integer getMemorySize() {
            return this.memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Environment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        @Override
        public final Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(Environment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(Runtime runtime) {
            this.runtime(runtime.toString());
            return this;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return this.deadLetterConfig != null ? this.deadLetterConfig.toBuilder() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        public final String getKMSKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKMSKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final TracingConfig.Builder getTracingConfig() {
            return this.tracingConfig != null ? this.tracingConfig.toBuilder() : null;
        }

        @Override
        public final Builder tracingConfig(TracingConfig tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        public final void setTracingConfig(TracingConfig.BuilderImpl tracingConfig) {
            this.tracingConfig = tracingConfig != null ? tracingConfig.build() : null;
        }

        public UpdateFunctionConfigurationRequest build() {
            return new UpdateFunctionConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateFunctionConfigurationRequest> {
        public Builder functionName(String var1);

        public Builder role(String var1);

        public Builder handler(String var1);

        public Builder description(String var1);

        public Builder timeout(Integer var1);

        public Builder memorySize(Integer var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().apply(vpcConfig)).build());
        }

        public Builder environment(Environment var1);

        default public Builder environment(Consumer<Environment.Builder> environment) {
            return this.environment((Environment)((Environment.Builder)Environment.builder().apply(environment)).build());
        }

        public Builder runtime(String var1);

        public Builder runtime(Runtime var1);

        public Builder deadLetterConfig(DeadLetterConfig var1);

        default public Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return this.deadLetterConfig((DeadLetterConfig)((DeadLetterConfig.Builder)DeadLetterConfig.builder().apply(deadLetterConfig)).build());
        }

        public Builder kmsKeyArn(String var1);

        public Builder tracingConfig(TracingConfig var1);

        default public Builder tracingConfig(Consumer<TracingConfig.Builder> tracingConfig) {
            return this.tracingConfig((TracingConfig)((TracingConfig.Builder)TracingConfig.builder().apply(tracingConfig)).build());
        }
    }
}

