/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration;
import software.amazon.awssdk.services.lambda.model.EventSourceMappingsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListEventSourceMappingsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListEventSourceMappingsResponse> {
    private final String nextMarker;
    private final List<EventSourceMappingConfiguration> eventSourceMappings;

    private ListEventSourceMappingsResponse(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.eventSourceMappings = builder.eventSourceMappings;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<EventSourceMappingConfiguration> eventSourceMappings() {
        return this.eventSourceMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceMappings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventSourceMappingsResponse)) {
            return false;
        }
        ListEventSourceMappingsResponse other = (ListEventSourceMappingsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.eventSourceMappings(), other.eventSourceMappings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.eventSourceMappings() != null) {
            sb.append("EventSourceMappings: ").append(this.eventSourceMappings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "EventSourceMappings": {
                return Optional.of(clazz.cast(this.eventSourceMappings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<EventSourceMappingConfiguration> eventSourceMappings;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventSourceMappingsResponse model) {
            this.nextMarker(model.nextMarker);
            this.eventSourceMappings(model.eventSourceMappings);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<EventSourceMappingConfiguration.Builder> getEventSourceMappings() {
            return this.eventSourceMappings != null ? (Collection)this.eventSourceMappings.stream().map(EventSourceMappingConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventSourceMappings(Collection<EventSourceMappingConfiguration> eventSourceMappings) {
            this.eventSourceMappings = EventSourceMappingsListCopier.copy(eventSourceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSourceMappings(EventSourceMappingConfiguration ... eventSourceMappings) {
            this.eventSourceMappings(Arrays.asList(eventSourceMappings));
            return this;
        }

        public final void setEventSourceMappings(Collection<EventSourceMappingConfiguration.BuilderImpl> eventSourceMappings) {
            this.eventSourceMappings = EventSourceMappingsListCopier.copyFromBuilder(eventSourceMappings);
        }

        public ListEventSourceMappingsResponse build() {
            return new ListEventSourceMappingsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListEventSourceMappingsResponse> {
        public Builder nextMarker(String var1);

        public Builder eventSourceMappings(Collection<EventSourceMappingConfiguration> var1);

        public Builder eventSourceMappings(EventSourceMappingConfiguration ... var1);
    }
}

