/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lambda.model.EnvironmentError;
import software.amazon.awssdk.services.lambda.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.lambda.transform.EnvironmentResponseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnvironmentResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, EnvironmentResponse> {
    private final Map<String, String> variables;
    private final EnvironmentError error;

    private EnvironmentResponse(BuilderImpl builder) {
        this.variables = builder.variables;
        this.error = builder.error;
    }

    public Map<String, String> variables() {
        return this.variables;
    }

    public EnvironmentError error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.variables());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentResponse)) {
            return false;
        }
        EnvironmentResponse other = (EnvironmentResponse)obj;
        return Objects.equals(this.variables(), other.variables()) && Objects.equals(this.error(), other.error());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.variables() != null) {
            sb.append("Variables: ").append(this.variables()).append(",");
        }
        if (this.error() != null) {
            sb.append("Error: ").append(this.error()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Variables": {
                return Optional.of(clazz.cast(this.variables()));
            }
            case "Error": {
                return Optional.of(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> variables;
        private EnvironmentError error;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentResponse model) {
            this.variables(model.variables);
            this.error(model.error);
        }

        public final Map<String, String> getVariables() {
            return this.variables;
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = EnvironmentVariablesCopier.copy(variables);
            return this;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = EnvironmentVariablesCopier.copy(variables);
        }

        public final EnvironmentError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        @Override
        public final Builder error(EnvironmentError error) {
            this.error = error;
            return this;
        }

        public final void setError(EnvironmentError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        public EnvironmentResponse build() {
            return new EnvironmentResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentResponse> {
        public Builder variables(Map<String, String> var1);

        public Builder error(EnvironmentError var1);

        default public Builder error(Consumer<EnvironmentError.Builder> error) {
            return this.error((EnvironmentError)((EnvironmentError.Builder)EnvironmentError.builder().apply(error)).build());
        }
    }
}

