/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.TagResourceRequest;

@SdkInternalApi
public class TagResourceRequestModelMarshaller {
    private static final MarshallingInfo<String> RESOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("ARN").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final TagResourceRequestModelMarshaller INSTANCE = new TagResourceRequestModelMarshaller();

    public static TagResourceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TagResourceRequest tagResourceRequest, ProtocolMarshaller protocolMarshaller) {
        if (tagResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)tagResourceRequest.resource(), RESOURCE_BINDING);
            protocolMarshaller.marshall(tagResourceRequest.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

