/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lambda.model.AliasConfiguration;
import software.amazon.awssdk.services.lambda.model.AliasListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAliasesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListAliasesResponse> {
    private final String nextMarker;
    private final List<AliasConfiguration> aliases;

    private ListAliasesResponse(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.aliases = builder.aliases;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<AliasConfiguration> aliases() {
        return this.aliases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.aliases() == null ? 0 : this.aliases().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAliasesResponse)) {
            return false;
        }
        ListAliasesResponse other = (ListAliasesResponse)((Object)obj);
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.aliases() == null ^ this.aliases() == null) {
            return false;
        }
        return other.aliases() == null || other.aliases().equals(this.aliases());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.aliases() != null) {
            sb.append("Aliases: ").append(this.aliases()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "Aliases": {
                return Optional.of(clazz.cast(this.aliases()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<AliasConfiguration> aliases;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAliasesResponse model) {
            this.nextMarker(model.nextMarker);
            this.aliases(model.aliases);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<AliasConfiguration.Builder> getAliases() {
            return this.aliases != null ? (Collection)this.aliases.stream().map(AliasConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aliases(Collection<AliasConfiguration> aliases) {
            this.aliases = AliasListCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(AliasConfiguration ... aliases) {
            this.aliases(Arrays.asList(aliases));
            return this;
        }

        public final void setAliases(Collection<AliasConfiguration.BuilderImpl> aliases) {
            this.aliases = AliasListCopier.copyFromBuilder(aliases);
        }

        public ListAliasesResponse build() {
            return new ListAliasesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListAliasesResponse> {
        public Builder nextMarker(String var1);

        public Builder aliases(Collection<AliasConfiguration> var1);

        public Builder aliases(AliasConfiguration ... var1);
    }
}

