/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.nio.ByteBuffer;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InvokeResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, InvokeResponse> {
    private final Integer statusCode;
    private final String functionError;
    private final String logResult;
    private final ByteBuffer payload;

    private InvokeResponse(BuilderImpl builder) {
        this.statusCode = builder.statusCode;
        this.functionError = builder.functionError;
        this.logResult = builder.logResult;
        this.payload = builder.payload;
    }

    public Integer statusCode() {
        return this.statusCode;
    }

    public String functionError() {
        return this.functionError;
    }

    public String logResult() {
        return this.logResult;
    }

    public ByteBuffer payload() {
        return this.payload == null ? null : this.payload.asReadOnlyBuffer();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.statusCode() == null ? 0 : this.statusCode().hashCode());
        hashCode = 31 * hashCode + (this.functionError() == null ? 0 : this.functionError().hashCode());
        hashCode = 31 * hashCode + (this.logResult() == null ? 0 : this.logResult().hashCode());
        hashCode = 31 * hashCode + (this.payload() == null ? 0 : this.payload().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeResponse)) {
            return false;
        }
        InvokeResponse other = (InvokeResponse)((Object)obj);
        if (other.statusCode() == null ^ this.statusCode() == null) {
            return false;
        }
        if (other.statusCode() != null && !other.statusCode().equals(this.statusCode())) {
            return false;
        }
        if (other.functionError() == null ^ this.functionError() == null) {
            return false;
        }
        if (other.functionError() != null && !other.functionError().equals(this.functionError())) {
            return false;
        }
        if (other.logResult() == null ^ this.logResult() == null) {
            return false;
        }
        if (other.logResult() != null && !other.logResult().equals(this.logResult())) {
            return false;
        }
        if (other.payload() == null ^ this.payload() == null) {
            return false;
        }
        return other.payload() == null || other.payload().equals(this.payload());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.statusCode() != null) {
            sb.append("StatusCode: ").append(this.statusCode()).append(",");
        }
        if (this.functionError() != null) {
            sb.append("FunctionError: ").append(this.functionError()).append(",");
        }
        if (this.logResult() != null) {
            sb.append("LogResult: ").append(this.logResult()).append(",");
        }
        if (this.payload() != null) {
            sb.append("Payload: ").append(this.payload()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StatusCode": {
                return Optional.of(clazz.cast(this.statusCode()));
            }
            case "FunctionError": {
                return Optional.of(clazz.cast(this.functionError()));
            }
            case "LogResult": {
                return Optional.of(clazz.cast(this.logResult()));
            }
            case "Payload": {
                return Optional.of(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer statusCode;
        private String functionError;
        private String logResult;
        private ByteBuffer payload;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeResponse model) {
            this.statusCode(model.statusCode);
            this.functionError(model.functionError);
            this.logResult(model.logResult);
            this.payload(model.payload);
        }

        public final Integer getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public final String getFunctionError() {
            return this.functionError;
        }

        @Override
        public final Builder functionError(String functionError) {
            this.functionError = functionError;
            return this;
        }

        public final void setFunctionError(String functionError) {
            this.functionError = functionError;
        }

        public final String getLogResult() {
            return this.logResult;
        }

        @Override
        public final Builder logResult(String logResult) {
            this.logResult = logResult;
            return this;
        }

        public final void setLogResult(String logResult) {
            this.logResult = logResult;
        }

        public final ByteBuffer getPayload() {
            return this.payload;
        }

        @Override
        public final Builder payload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy((ByteBuffer)payload);
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy((ByteBuffer)payload);
        }

        public InvokeResponse build() {
            return new InvokeResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InvokeResponse> {
        public Builder statusCode(Integer var1);

        public Builder functionError(String var1);

        public Builder logResult(String var1);

        public Builder payload(ByteBuffer var1);
    }
}

