/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddPermissionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddPermissionRequest> {
    private final String functionName;
    private final String statementId;
    private final String action;
    private final String principal;
    private final String sourceArn;
    private final String sourceAccount;
    private final String eventSourceToken;
    private final String qualifier;

    private AddPermissionRequest(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.statementId = builder.statementId;
        this.action = builder.action;
        this.principal = builder.principal;
        this.sourceArn = builder.sourceArn;
        this.sourceAccount = builder.sourceAccount;
        this.eventSourceToken = builder.eventSourceToken;
        this.qualifier = builder.qualifier;
    }

    public String functionName() {
        return this.functionName;
    }

    public String statementId() {
        return this.statementId;
    }

    public String action() {
        return this.action;
    }

    public String principal() {
        return this.principal;
    }

    public String sourceArn() {
        return this.sourceArn;
    }

    public String sourceAccount() {
        return this.sourceAccount;
    }

    public String eventSourceToken() {
        return this.eventSourceToken;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.functionName() == null ? 0 : this.functionName().hashCode());
        hashCode = 31 * hashCode + (this.statementId() == null ? 0 : this.statementId().hashCode());
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        hashCode = 31 * hashCode + (this.principal() == null ? 0 : this.principal().hashCode());
        hashCode = 31 * hashCode + (this.sourceArn() == null ? 0 : this.sourceArn().hashCode());
        hashCode = 31 * hashCode + (this.sourceAccount() == null ? 0 : this.sourceAccount().hashCode());
        hashCode = 31 * hashCode + (this.eventSourceToken() == null ? 0 : this.eventSourceToken().hashCode());
        hashCode = 31 * hashCode + (this.qualifier() == null ? 0 : this.qualifier().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPermissionRequest)) {
            return false;
        }
        AddPermissionRequest other = (AddPermissionRequest)((Object)obj);
        if (other.functionName() == null ^ this.functionName() == null) {
            return false;
        }
        if (other.functionName() != null && !other.functionName().equals(this.functionName())) {
            return false;
        }
        if (other.statementId() == null ^ this.statementId() == null) {
            return false;
        }
        if (other.statementId() != null && !other.statementId().equals(this.statementId())) {
            return false;
        }
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.principal() == null ^ this.principal() == null) {
            return false;
        }
        if (other.principal() != null && !other.principal().equals(this.principal())) {
            return false;
        }
        if (other.sourceArn() == null ^ this.sourceArn() == null) {
            return false;
        }
        if (other.sourceArn() != null && !other.sourceArn().equals(this.sourceArn())) {
            return false;
        }
        if (other.sourceAccount() == null ^ this.sourceAccount() == null) {
            return false;
        }
        if (other.sourceAccount() != null && !other.sourceAccount().equals(this.sourceAccount())) {
            return false;
        }
        if (other.eventSourceToken() == null ^ this.eventSourceToken() == null) {
            return false;
        }
        if (other.eventSourceToken() != null && !other.eventSourceToken().equals(this.eventSourceToken())) {
            return false;
        }
        if (other.qualifier() == null ^ this.qualifier() == null) {
            return false;
        }
        return other.qualifier() == null || other.qualifier().equals(this.qualifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.functionName() != null) {
            sb.append("FunctionName: ").append(this.functionName()).append(",");
        }
        if (this.statementId() != null) {
            sb.append("StatementId: ").append(this.statementId()).append(",");
        }
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.principal() != null) {
            sb.append("Principal: ").append(this.principal()).append(",");
        }
        if (this.sourceArn() != null) {
            sb.append("SourceArn: ").append(this.sourceArn()).append(",");
        }
        if (this.sourceAccount() != null) {
            sb.append("SourceAccount: ").append(this.sourceAccount()).append(",");
        }
        if (this.eventSourceToken() != null) {
            sb.append("EventSourceToken: ").append(this.eventSourceToken()).append(",");
        }
        if (this.qualifier() != null) {
            sb.append("Qualifier: ").append(this.qualifier()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.of(clazz.cast(this.functionName()));
            }
            case "StatementId": {
                return Optional.of(clazz.cast(this.statementId()));
            }
            case "Action": {
                return Optional.of(clazz.cast(this.action()));
            }
            case "Principal": {
                return Optional.of(clazz.cast(this.principal()));
            }
            case "SourceArn": {
                return Optional.of(clazz.cast(this.sourceArn()));
            }
            case "SourceAccount": {
                return Optional.of(clazz.cast(this.sourceAccount()));
            }
            case "EventSourceToken": {
                return Optional.of(clazz.cast(this.eventSourceToken()));
            }
            case "Qualifier": {
                return Optional.of(clazz.cast(this.qualifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String functionName;
        private String statementId;
        private String action;
        private String principal;
        private String sourceArn;
        private String sourceAccount;
        private String eventSourceToken;
        private String qualifier;

        private BuilderImpl() {
        }

        private BuilderImpl(AddPermissionRequest model) {
            this.functionName(model.functionName);
            this.statementId(model.statementId);
            this.action(model.action);
            this.principal(model.principal);
            this.sourceArn(model.sourceArn);
            this.sourceAccount(model.sourceAccount);
            this.eventSourceToken(model.eventSourceToken);
            this.qualifier(model.qualifier);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getStatementId() {
            return this.statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getPrincipal() {
            return this.principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getSourceAccount() {
            return this.sourceAccount;
        }

        @Override
        public final Builder sourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        public final void setSourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
        }

        public final String getEventSourceToken() {
            return this.eventSourceToken;
        }

        @Override
        public final Builder eventSourceToken(String eventSourceToken) {
            this.eventSourceToken = eventSourceToken;
            return this;
        }

        public final void setEventSourceToken(String eventSourceToken) {
            this.eventSourceToken = eventSourceToken;
        }

        public final String getQualifier() {
            return this.qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        public AddPermissionRequest build() {
            return new AddPermissionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddPermissionRequest> {
        public Builder functionName(String var1);

        public Builder statementId(String var1);

        public Builder action(String var1);

        public Builder principal(String var1);

        public Builder sourceArn(String var1);

        public Builder sourceAccount(String var1);

        public Builder eventSourceToken(String var1);

        public Builder qualifier(String var1);
    }
}

