/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lambda.transform.AccountUsageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AccountUsage
implements StructuredPojo,
ToCopyableBuilder<Builder, AccountUsage> {
    private final Long totalCodeSize;
    private final Long functionCount;

    private AccountUsage(BuilderImpl builder) {
        this.totalCodeSize = builder.totalCodeSize;
        this.functionCount = builder.functionCount;
    }

    public Long totalCodeSize() {
        return this.totalCodeSize;
    }

    public Long functionCount() {
        return this.functionCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.totalCodeSize() == null ? 0 : this.totalCodeSize().hashCode());
        hashCode = 31 * hashCode + (this.functionCount() == null ? 0 : this.functionCount().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountUsage)) {
            return false;
        }
        AccountUsage other = (AccountUsage)obj;
        if (other.totalCodeSize() == null ^ this.totalCodeSize() == null) {
            return false;
        }
        if (other.totalCodeSize() != null && !other.totalCodeSize().equals(this.totalCodeSize())) {
            return false;
        }
        if (other.functionCount() == null ^ this.functionCount() == null) {
            return false;
        }
        return other.functionCount() == null || other.functionCount().equals(this.functionCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.totalCodeSize() != null) {
            sb.append("TotalCodeSize: ").append(this.totalCodeSize()).append(",");
        }
        if (this.functionCount() != null) {
            sb.append("FunctionCount: ").append(this.functionCount()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalCodeSize": {
                return Optional.of(clazz.cast(this.totalCodeSize()));
            }
            case "FunctionCount": {
                return Optional.of(clazz.cast(this.functionCount()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountUsageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long totalCodeSize;
        private Long functionCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountUsage model) {
            this.totalCodeSize(model.totalCodeSize);
            this.functionCount(model.functionCount);
        }

        public final Long getTotalCodeSize() {
            return this.totalCodeSize;
        }

        @Override
        public final Builder totalCodeSize(Long totalCodeSize) {
            this.totalCodeSize = totalCodeSize;
            return this;
        }

        public final void setTotalCodeSize(Long totalCodeSize) {
            this.totalCodeSize = totalCodeSize;
        }

        public final Long getFunctionCount() {
            return this.functionCount;
        }

        @Override
        public final Builder functionCount(Long functionCount) {
            this.functionCount = functionCount;
            return this;
        }

        public final void setFunctionCount(Long functionCount) {
            this.functionCount = functionCount;
        }

        public AccountUsage build() {
            return new AccountUsage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccountUsage> {
        public Builder totalCodeSize(Long var1);

        public Builder functionCount(Long var1);
    }
}

