/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import java.io.InputStream;
import java.nio.ByteBuffer;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.utils.IoUtils;

public class InvokeResponseUnmarshaller
implements Unmarshaller<InvokeResponse, JsonUnmarshallerContext> {
    private static final InvokeResponseUnmarshaller INSTANCE = new InvokeResponseUnmarshaller();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvokeResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        InvokeResponse.Builder invokeResponseBuilder = InvokeResponse.builder();
        if (context.isStartOfDocument()) {
            if (context.getHeader("X-Amz-Function-Error") != null) {
                context.setCurrentHeader("X-Amz-Function-Error");
                invokeResponseBuilder.functionError((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
            if (context.getHeader("X-Amz-Log-Result") != null) {
                context.setCurrentHeader("X-Amz-Log-Result");
                invokeResponseBuilder.logResult((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
        }
        invokeResponseBuilder.statusCode(context.getHttpResponse().getStatusCode());
        InputStream is = context.getHttpResponse().getContent();
        if (is != null) {
            try {
                invokeResponseBuilder.payload(ByteBuffer.wrap(IoUtils.toByteArray((InputStream)is)));
            }
            finally {
                IoUtils.closeQuietly((AutoCloseable)is, null);
            }
        }
        return (InvokeResponse)((Object)invokeResponseBuilder.build());
    }

    public static InvokeResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

