/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lambda.model.DeadLetterConfig;

public class DeadLetterConfigUnmarshaller
implements Unmarshaller<DeadLetterConfig, JsonUnmarshallerContext> {
    private static final DeadLetterConfigUnmarshaller INSTANCE = new DeadLetterConfigUnmarshaller();

    public DeadLetterConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        DeadLetterConfig.Builder deadLetterConfigBuilder = DeadLetterConfig.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("TargetArn", targetDepth)) {
                    context.nextToken();
                    deadLetterConfigBuilder.targetArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DeadLetterConfig)deadLetterConfigBuilder.build();
    }

    public static DeadLetterConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

