/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.PublishVersionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PublishVersionRequestModelMarshaller {
    private static final MarshallingInfo<String> FUNCTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("FunctionName").isBinary(false).build();
    private static final MarshallingInfo<String> CODESHA256_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeSha256").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> REVISIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RevisionId").isBinary(false).build();
    private static final PublishVersionRequestModelMarshaller INSTANCE = new PublishVersionRequestModelMarshaller();

    private PublishVersionRequestModelMarshaller() {
    }

    public static PublishVersionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PublishVersionRequest publishVersionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)publishVersionRequest), (String)"publishVersionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)publishVersionRequest.functionName(), FUNCTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)publishVersionRequest.codeSha256(), CODESHA256_BINDING);
            protocolMarshaller.marshall((Object)publishVersionRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)publishVersionRequest.revisionId(), REVISIONID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

