/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lambda.transform.AccountLimitMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountLimit
implements StructuredPojo,
ToCopyableBuilder<Builder, AccountLimit> {
    private final Long totalCodeSize;
    private final Long codeSizeUnzipped;
    private final Long codeSizeZipped;
    private final Integer concurrentExecutions;
    private final Integer unreservedConcurrentExecutions;

    private AccountLimit(BuilderImpl builder) {
        this.totalCodeSize = builder.totalCodeSize;
        this.codeSizeUnzipped = builder.codeSizeUnzipped;
        this.codeSizeZipped = builder.codeSizeZipped;
        this.concurrentExecutions = builder.concurrentExecutions;
        this.unreservedConcurrentExecutions = builder.unreservedConcurrentExecutions;
    }

    public Long totalCodeSize() {
        return this.totalCodeSize;
    }

    public Long codeSizeUnzipped() {
        return this.codeSizeUnzipped;
    }

    public Long codeSizeZipped() {
        return this.codeSizeZipped;
    }

    public Integer concurrentExecutions() {
        return this.concurrentExecutions;
    }

    public Integer unreservedConcurrentExecutions() {
        return this.unreservedConcurrentExecutions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCodeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSizeUnzipped());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSizeZipped());
        hashCode = 31 * hashCode + Objects.hashCode(this.concurrentExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.unreservedConcurrentExecutions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountLimit)) {
            return false;
        }
        AccountLimit other = (AccountLimit)obj;
        return Objects.equals(this.totalCodeSize(), other.totalCodeSize()) && Objects.equals(this.codeSizeUnzipped(), other.codeSizeUnzipped()) && Objects.equals(this.codeSizeZipped(), other.codeSizeZipped()) && Objects.equals(this.concurrentExecutions(), other.concurrentExecutions()) && Objects.equals(this.unreservedConcurrentExecutions(), other.unreservedConcurrentExecutions());
    }

    public String toString() {
        return ToString.builder((String)"AccountLimit").add("TotalCodeSize", (Object)this.totalCodeSize()).add("CodeSizeUnzipped", (Object)this.codeSizeUnzipped()).add("CodeSizeZipped", (Object)this.codeSizeZipped()).add("ConcurrentExecutions", (Object)this.concurrentExecutions()).add("UnreservedConcurrentExecutions", (Object)this.unreservedConcurrentExecutions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalCodeSize": {
                return Optional.ofNullable(clazz.cast(this.totalCodeSize()));
            }
            case "CodeSizeUnzipped": {
                return Optional.ofNullable(clazz.cast(this.codeSizeUnzipped()));
            }
            case "CodeSizeZipped": {
                return Optional.ofNullable(clazz.cast(this.codeSizeZipped()));
            }
            case "ConcurrentExecutions": {
                return Optional.ofNullable(clazz.cast(this.concurrentExecutions()));
            }
            case "UnreservedConcurrentExecutions": {
                return Optional.ofNullable(clazz.cast(this.unreservedConcurrentExecutions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountLimitMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long totalCodeSize;
        private Long codeSizeUnzipped;
        private Long codeSizeZipped;
        private Integer concurrentExecutions;
        private Integer unreservedConcurrentExecutions;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountLimit model) {
            this.totalCodeSize(model.totalCodeSize);
            this.codeSizeUnzipped(model.codeSizeUnzipped);
            this.codeSizeZipped(model.codeSizeZipped);
            this.concurrentExecutions(model.concurrentExecutions);
            this.unreservedConcurrentExecutions(model.unreservedConcurrentExecutions);
        }

        public final Long getTotalCodeSize() {
            return this.totalCodeSize;
        }

        @Override
        public final Builder totalCodeSize(Long totalCodeSize) {
            this.totalCodeSize = totalCodeSize;
            return this;
        }

        public final void setTotalCodeSize(Long totalCodeSize) {
            this.totalCodeSize = totalCodeSize;
        }

        public final Long getCodeSizeUnzipped() {
            return this.codeSizeUnzipped;
        }

        @Override
        public final Builder codeSizeUnzipped(Long codeSizeUnzipped) {
            this.codeSizeUnzipped = codeSizeUnzipped;
            return this;
        }

        public final void setCodeSizeUnzipped(Long codeSizeUnzipped) {
            this.codeSizeUnzipped = codeSizeUnzipped;
        }

        public final Long getCodeSizeZipped() {
            return this.codeSizeZipped;
        }

        @Override
        public final Builder codeSizeZipped(Long codeSizeZipped) {
            this.codeSizeZipped = codeSizeZipped;
            return this;
        }

        public final void setCodeSizeZipped(Long codeSizeZipped) {
            this.codeSizeZipped = codeSizeZipped;
        }

        public final Integer getConcurrentExecutions() {
            return this.concurrentExecutions;
        }

        @Override
        public final Builder concurrentExecutions(Integer concurrentExecutions) {
            this.concurrentExecutions = concurrentExecutions;
            return this;
        }

        public final void setConcurrentExecutions(Integer concurrentExecutions) {
            this.concurrentExecutions = concurrentExecutions;
        }

        public final Integer getUnreservedConcurrentExecutions() {
            return this.unreservedConcurrentExecutions;
        }

        @Override
        public final Builder unreservedConcurrentExecutions(Integer unreservedConcurrentExecutions) {
            this.unreservedConcurrentExecutions = unreservedConcurrentExecutions;
            return this;
        }

        public final void setUnreservedConcurrentExecutions(Integer unreservedConcurrentExecutions) {
            this.unreservedConcurrentExecutions = unreservedConcurrentExecutions;
        }

        public AccountLimit build() {
            return new AccountLimit(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccountLimit> {
        public Builder totalCodeSize(Long var1);

        public Builder codeSizeUnzipped(Long var1);

        public Builder codeSizeZipped(Long var1);

        public Builder concurrentExecutions(Integer var1);

        public Builder unreservedConcurrentExecutions(Integer var1);
    }
}

