/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.FunctionCodeLocation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FunctionCodeLocationMarshaller {
    private static final MarshallingInfo<String> REPOSITORYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RepositoryType").isBinary(false).build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Location").isBinary(false).build();
    private static final FunctionCodeLocationMarshaller INSTANCE = new FunctionCodeLocationMarshaller();

    private FunctionCodeLocationMarshaller() {
    }

    public static FunctionCodeLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FunctionCodeLocation functionCodeLocation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)functionCodeLocation, (String)"functionCodeLocation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)functionCodeLocation.repositoryType(), REPOSITORYTYPE_BINDING);
            protocolMarshaller.marshall((Object)functionCodeLocation.location(), LOCATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

