/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.AliasRoutingConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AliasRoutingConfigurationMarshaller {
    private static final MarshallingInfo<Map> ADDITIONALVERSIONWEIGHTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalVersionWeights").isBinary(false).build();
    private static final AliasRoutingConfigurationMarshaller INSTANCE = new AliasRoutingConfigurationMarshaller();

    private AliasRoutingConfigurationMarshaller() {
    }

    public static AliasRoutingConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AliasRoutingConfiguration aliasRoutingConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)aliasRoutingConfiguration, (String)"aliasRoutingConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(aliasRoutingConfiguration.additionalVersionWeights(), ADDITIONALVERSIONWEIGHTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

