/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.ListFunctionsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsResponse;

public class ListFunctionsIterable
implements SdkIterable<ListFunctionsResponse> {
    private final LambdaClient client;
    private final ListFunctionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFunctionsIterable(LambdaClient client, ListFunctionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFunctionsResponseFetcher();
    }

    public Iterator<ListFunctionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FunctionConfiguration> functions() {
        Function<ListFunctionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.functions() != null) {
                return response.functions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListFunctionsIterable resume(ListFunctionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListFunctionsIterable(this.client, (ListFunctionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new ListFunctionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListFunctionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListFunctionsResponseFetcher
    implements SyncPageFetcher<ListFunctionsResponse> {
        private ListFunctionsResponseFetcher() {
        }

        public boolean hasNextPage(ListFunctionsResponse previousPage) {
            return previousPage.nextMarker() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextMarker()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextMarker());
        }

        public ListFunctionsResponse nextPage(ListFunctionsResponse previousPage) {
            if (previousPage == null) {
                return ListFunctionsIterable.this.client.listFunctions(ListFunctionsIterable.this.firstRequest);
            }
            return ListFunctionsIterable.this.client.listFunctions((ListFunctionsRequest)((Object)ListFunctionsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

