/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.adapter.StringToSdkBytesAdapter;
import software.amazon.awssdk.services.lambda.model.InvocationType;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.model.LogType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, InvokeRequest> {
    private final String functionName;
    private final String invocationType;
    private final String logType;
    private final String clientContext;
    private final SdkBytes payload;
    private final String qualifier;

    private InvokeRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.invocationType = builder.invocationType;
        this.logType = builder.logType;
        this.clientContext = builder.clientContext;
        this.payload = builder.payload;
        this.qualifier = builder.qualifier;
    }

    public String functionName() {
        return this.functionName;
    }

    public InvocationType invocationType() {
        return InvocationType.fromValue(this.invocationType);
    }

    public String invocationTypeAsString() {
        return this.invocationType;
    }

    public LogType logType() {
        return LogType.fromValue(this.logType);
    }

    public String logTypeAsString() {
        return this.logType;
    }

    public String clientContext() {
        return this.clientContext;
    }

    public SdkBytes payload() {
        return this.payload;
    }

    public String qualifier() {
        return this.qualifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeRequest)) {
            return false;
        }
        InvokeRequest other = (InvokeRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.invocationTypeAsString(), other.invocationTypeAsString()) && Objects.equals(this.logTypeAsString(), other.logTypeAsString()) && Objects.equals(this.clientContext(), other.clientContext()) && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.qualifier(), other.qualifier());
    }

    public String toString() {
        return ToString.builder((String)"InvokeRequest").add("FunctionName", (Object)this.functionName()).add("InvocationType", (Object)this.invocationTypeAsString()).add("LogType", (Object)this.logTypeAsString()).add("ClientContext", (Object)this.clientContext()).add("Payload", (Object)this.payload()).add("Qualifier", (Object)this.qualifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "InvocationType": {
                return Optional.ofNullable(clazz.cast(this.invocationTypeAsString()));
            }
            case "LogType": {
                return Optional.ofNullable(clazz.cast(this.logTypeAsString()));
            }
            case "ClientContext": {
                return Optional.ofNullable(clazz.cast(this.clientContext()));
            }
            case "Payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "Qualifier": {
                return Optional.ofNullable(clazz.cast(this.qualifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private String invocationType;
        private String logType;
        private String clientContext;
        private SdkBytes payload;
        private String qualifier;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeRequest model) {
            super(model);
            this.functionName(model.functionName);
            this.invocationType(model.invocationType);
            this.logType(model.logType);
            this.clientContext(model.clientContext);
            this.payload(model.payload);
            this.qualifier(model.qualifier);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getInvocationType() {
            return this.invocationType;
        }

        @Override
        public final Builder invocationType(String invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        @Override
        public final Builder invocationType(InvocationType invocationType) {
            this.invocationType(invocationType.toString());
            return this;
        }

        public final void setInvocationType(String invocationType) {
            this.invocationType = invocationType;
        }

        public final String getLogType() {
            return this.logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(LogType logType) {
            this.logType(logType.toString());
            return this;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        public final String getClientContext() {
            return this.clientContext;
        }

        @Override
        public final Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public final void setClientContext(String clientContext) {
            this.clientContext = clientContext;
        }

        public final ByteBuffer getPayload() {
            return this.payload == null ? null : this.payload.asByteBuffer();
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = StandardMemberCopier.copy((SdkBytes)payload);
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload(payload == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)payload));
        }

        @Override
        public Builder payload(String payload) {
            this.payload(new StringToSdkBytesAdapter().adapt(payload));
            return this;
        }

        public void setPayload(String payload) {
            this.payload = new StringToSdkBytesAdapter().adapt(payload);
        }

        public final String getQualifier() {
            return this.qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeRequest build() {
            return new InvokeRequest(this);
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    CopyableBuilder<Builder, InvokeRequest> {
        public Builder functionName(String var1);

        public Builder invocationType(String var1);

        public Builder invocationType(InvocationType var1);

        public Builder logType(String var1);

        public Builder logType(LogType var1);

        public Builder clientContext(String var1);

        public Builder payload(SdkBytes var1);

        public Builder payload(String var1);

        public Builder qualifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

