/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.lambda.model.EventSourcePosition;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEventSourceMappingRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, CreateEventSourceMappingRequest> {
    private final String eventSourceArn;
    private final String functionName;
    private final Boolean enabled;
    private final Integer batchSize;
    private final String startingPosition;
    private final Instant startingPositionTimestamp;

    private CreateEventSourceMappingRequest(BuilderImpl builder) {
        super(builder);
        this.eventSourceArn = builder.eventSourceArn;
        this.functionName = builder.functionName;
        this.enabled = builder.enabled;
        this.batchSize = builder.batchSize;
        this.startingPosition = builder.startingPosition;
        this.startingPositionTimestamp = builder.startingPositionTimestamp;
    }

    public String eventSourceArn() {
        return this.eventSourceArn;
    }

    public String functionName() {
        return this.functionName;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Integer batchSize() {
        return this.batchSize;
    }

    public EventSourcePosition startingPosition() {
        return EventSourcePosition.fromValue(this.startingPosition);
    }

    public String startingPositionAsString() {
        return this.startingPosition;
    }

    public Instant startingPositionTimestamp() {
        return this.startingPositionTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingPositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingPositionTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventSourceMappingRequest)) {
            return false;
        }
        CreateEventSourceMappingRequest other = (CreateEventSourceMappingRequest)((Object)obj);
        return Objects.equals(this.eventSourceArn(), other.eventSourceArn()) && Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.batchSize(), other.batchSize()) && Objects.equals(this.startingPositionAsString(), other.startingPositionAsString()) && Objects.equals(this.startingPositionTimestamp(), other.startingPositionTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"CreateEventSourceMappingRequest").add("EventSourceArn", (Object)this.eventSourceArn()).add("FunctionName", (Object)this.functionName()).add("Enabled", (Object)this.enabled()).add("BatchSize", (Object)this.batchSize()).add("StartingPosition", (Object)this.startingPositionAsString()).add("StartingPositionTimestamp", (Object)this.startingPositionTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventSourceArn": {
                return Optional.ofNullable(clazz.cast(this.eventSourceArn()));
            }
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "BatchSize": {
                return Optional.ofNullable(clazz.cast(this.batchSize()));
            }
            case "StartingPosition": {
                return Optional.ofNullable(clazz.cast(this.startingPositionAsString()));
            }
            case "StartingPositionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startingPositionTimestamp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String eventSourceArn;
        private String functionName;
        private Boolean enabled;
        private Integer batchSize;
        private String startingPosition;
        private Instant startingPositionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventSourceMappingRequest model) {
            super(model);
            this.eventSourceArn(model.eventSourceArn);
            this.functionName(model.functionName);
            this.enabled(model.enabled);
            this.batchSize(model.batchSize);
            this.startingPosition(model.startingPosition);
            this.startingPositionTimestamp(model.startingPositionTimestamp);
        }

        public final String getEventSourceArn() {
            return this.eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        public final String getStartingPosition() {
            return this.startingPosition;
        }

        @Override
        public final Builder startingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        @Override
        public final Builder startingPosition(EventSourcePosition startingPosition) {
            this.startingPosition(startingPosition.toString());
            return this;
        }

        public final void setStartingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
        }

        public final Instant getStartingPositionTimestamp() {
            return this.startingPositionTimestamp;
        }

        @Override
        public final Builder startingPositionTimestamp(Instant startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
            return this;
        }

        public final void setStartingPositionTimestamp(Instant startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEventSourceMappingRequest build() {
            return new CreateEventSourceMappingRequest(this);
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    CopyableBuilder<Builder, CreateEventSourceMappingRequest> {
        public Builder eventSourceArn(String var1);

        public Builder functionName(String var1);

        public Builder enabled(Boolean var1);

        public Builder batchSize(Integer var1);

        public Builder startingPosition(String var1);

        public Builder startingPosition(EventSourcePosition var1);

        public Builder startingPositionTimestamp(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

