/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.lambda.model.AliasRoutingConfiguration;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAliasResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, CreateAliasResponse> {
    private final String aliasArn;
    private final String name;
    private final String functionVersion;
    private final String description;
    private final AliasRoutingConfiguration routingConfig;
    private final String revisionId;

    private CreateAliasResponse(BuilderImpl builder) {
        super(builder);
        this.aliasArn = builder.aliasArn;
        this.name = builder.name;
        this.functionVersion = builder.functionVersion;
        this.description = builder.description;
        this.routingConfig = builder.routingConfig;
        this.revisionId = builder.revisionId;
    }

    public String aliasArn() {
        return this.aliasArn;
    }

    public String name() {
        return this.name;
    }

    public String functionVersion() {
        return this.functionVersion;
    }

    public String description() {
        return this.description;
    }

    public AliasRoutingConfiguration routingConfig() {
        return this.routingConfig;
    }

    public String revisionId() {
        return this.revisionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAliasResponse)) {
            return false;
        }
        CreateAliasResponse other = (CreateAliasResponse)((Object)obj);
        return Objects.equals(this.aliasArn(), other.aliasArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.functionVersion(), other.functionVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.routingConfig(), other.routingConfig()) && Objects.equals(this.revisionId(), other.revisionId());
    }

    public String toString() {
        return ToString.builder((String)"CreateAliasResponse").add("AliasArn", (Object)this.aliasArn()).add("Name", (Object)this.name()).add("FunctionVersion", (Object)this.functionVersion()).add("Description", (Object)this.description()).add("RoutingConfig", (Object)this.routingConfig()).add("RevisionId", (Object)this.revisionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AliasArn": {
                return Optional.ofNullable(clazz.cast(this.aliasArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "FunctionVersion": {
                return Optional.ofNullable(clazz.cast(this.functionVersion()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RoutingConfig": {
                return Optional.ofNullable(clazz.cast(this.routingConfig()));
            }
            case "RevisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String aliasArn;
        private String name;
        private String functionVersion;
        private String description;
        private AliasRoutingConfiguration routingConfig;
        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAliasResponse model) {
            super(model);
            this.aliasArn(model.aliasArn);
            this.name(model.name);
            this.functionVersion(model.functionVersion);
            this.description(model.description);
            this.routingConfig(model.routingConfig);
            this.revisionId(model.revisionId);
        }

        public final String getAliasArn() {
            return this.aliasArn;
        }

        @Override
        public final Builder aliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
            return this;
        }

        public final void setAliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFunctionVersion() {
            return this.functionVersion;
        }

        @Override
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final AliasRoutingConfiguration.Builder getRoutingConfig() {
            return this.routingConfig != null ? this.routingConfig.toBuilder() : null;
        }

        @Override
        public final Builder routingConfig(AliasRoutingConfiguration routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        public final void setRoutingConfig(AliasRoutingConfiguration.BuilderImpl routingConfig) {
            this.routingConfig = routingConfig != null ? routingConfig.build() : null;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public CreateAliasResponse build() {
            return new CreateAliasResponse(this);
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    CopyableBuilder<Builder, CreateAliasResponse> {
        public Builder aliasArn(String var1);

        public Builder name(String var1);

        public Builder functionVersion(String var1);

        public Builder description(String var1);

        public Builder routingConfig(AliasRoutingConfiguration var1);

        default public Builder routingConfig(Consumer<AliasRoutingConfiguration.Builder> routingConfig) {
            return this.routingConfig((AliasRoutingConfiguration)((AliasRoutingConfiguration.Builder)AliasRoutingConfiguration.builder().applyMutation(routingConfig)).build());
        }

        public Builder revisionId(String var1);
    }
}

