/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.TracingConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TracingConfigMarshaller {
    private static final MarshallingInfo<String> MODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mode").isBinary(false).build();
    private static final TracingConfigMarshaller INSTANCE = new TracingConfigMarshaller();

    private TracingConfigMarshaller() {
    }

    public static TracingConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TracingConfig tracingConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)tracingConfig, (String)"tracingConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)tracingConfig.modeAsString(), MODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

