/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InvokeRequestModelMarshaller {
    private static final MarshallingInfo<String> FUNCTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("FunctionName").isBinary(false).build();
    private static final MarshallingInfo<String> INVOCATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amz-Invocation-Type").isBinary(false).build();
    private static final MarshallingInfo<String> LOGTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amz-Log-Type").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amz-Client-Context").isBinary(false).build();
    private static final MarshallingInfo<ByteBuffer> PAYLOAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).isBinary(true).build();
    private static final MarshallingInfo<String> QUALIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("Qualifier").isBinary(false).build();
    private static final InvokeRequestModelMarshaller INSTANCE = new InvokeRequestModelMarshaller();

    private InvokeRequestModelMarshaller() {
    }

    public static InvokeRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InvokeRequest invokeRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)invokeRequest), (String)"invokeRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)invokeRequest.functionName(), FUNCTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)invokeRequest.invocationTypeAsString(), INVOCATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)invokeRequest.logTypeAsString(), LOGTYPE_BINDING);
            protocolMarshaller.marshall((Object)invokeRequest.clientContext(), CLIENTCONTEXT_BINDING);
            protocolMarshaller.marshall((Object)invokeRequest.payload(), PAYLOAD_BINDING);
            protocolMarshaller.marshall((Object)invokeRequest.qualifier(), QUALIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

