/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lambda.model.EnvironmentResponse;

@SdkInternalApi
public class EnvironmentResponseMarshaller {
    private static final MarshallingInfo<Map> VARIABLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Variables").build();
    private static final MarshallingInfo<StructuredPojo> ERROR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Error").build();
    private static final EnvironmentResponseMarshaller instance = new EnvironmentResponseMarshaller();

    public static EnvironmentResponseMarshaller getInstance() {
        return instance;
    }

    public void marshall(EnvironmentResponse environmentResponse, ProtocolMarshaller protocolMarshaller) {
        if (environmentResponse == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(environmentResponse.variables(), VARIABLES_BINDING);
            protocolMarshaller.marshall((Object)environmentResponse.error(), ERROR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

