/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.AliasConfiguration;

@SdkInternalApi
public class AliasConfigurationMarshaller {
    private static final MarshallingInfo<String> ALIASARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AliasArn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> FUNCTIONVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionVersion").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final AliasConfigurationMarshaller instance = new AliasConfigurationMarshaller();

    public static AliasConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(AliasConfiguration aliasConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (aliasConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)aliasConfiguration.aliasArn(), ALIASARN_BINDING);
            protocolMarshaller.marshall((Object)aliasConfiguration.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)aliasConfiguration.functionVersion(), FUNCTIONVERSION_BINDING);
            protocolMarshaller.marshall((Object)aliasConfiguration.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

