/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.lambda.model.FunctionCodeLocation;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetFunctionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetFunctionResponse> {
    private final FunctionConfiguration configuration;
    private final FunctionCodeLocation code;
    private final Map<String, String> tags;

    private GetFunctionResponse(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.code = builder.code;
        this.tags = builder.tags;
    }

    public FunctionConfiguration configuration() {
        return this.configuration;
    }

    public FunctionCodeLocation code() {
        return this.code;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.configuration() == null ? 0 : this.configuration().hashCode());
        hashCode = 31 * hashCode + (this.code() == null ? 0 : this.code().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionResponse)) {
            return false;
        }
        GetFunctionResponse other = (GetFunctionResponse)((Object)obj);
        if (other.configuration() == null ^ this.configuration() == null) {
            return false;
        }
        if (other.configuration() != null && !other.configuration().equals(this.configuration())) {
            return false;
        }
        if (other.code() == null ^ this.code() == null) {
            return false;
        }
        if (other.code() != null && !other.code().equals(this.code())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configuration() != null) {
            sb.append("Configuration: ").append(this.configuration()).append(",");
        }
        if (this.code() != null) {
            sb.append("Code: ").append(this.code()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private FunctionConfiguration configuration;
        private FunctionCodeLocation code;
        private Map<String, String> tags = new SdkInternalMap();

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionResponse model) {
            this.setConfiguration(model.configuration);
            this.setCode(model.code);
            this.setTags(model.tags);
        }

        public final FunctionConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        public final Builder configuration(FunctionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(FunctionConfiguration configuration) {
            this.configuration = configuration;
        }

        public final FunctionCodeLocation getCode() {
            return this.code;
        }

        @Override
        public final Builder code(FunctionCodeLocation code) {
            this.code = code;
            return this;
        }

        public final void setCode(FunctionCodeLocation code) {
            this.code = code;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public GetFunctionResponse build() {
            return new GetFunctionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetFunctionResponse> {
        public Builder configuration(FunctionConfiguration var1);

        public Builder code(FunctionCodeLocation var1);

        public Builder tags(Map<String, String> var1);
    }
}

