/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.lambda.model.EventSourcePosition;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateEventSourceMappingRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateEventSourceMappingRequest> {
    private final String eventSourceArn;
    private final String functionName;
    private final Boolean enabled;
    private final Integer batchSize;
    private final String startingPosition;
    private final Date startingPositionTimestamp;

    private CreateEventSourceMappingRequest(BuilderImpl builder) {
        this.eventSourceArn = builder.eventSourceArn;
        this.functionName = builder.functionName;
        this.enabled = builder.enabled;
        this.batchSize = builder.batchSize;
        this.startingPosition = builder.startingPosition;
        this.startingPositionTimestamp = builder.startingPositionTimestamp;
    }

    public String eventSourceArn() {
        return this.eventSourceArn;
    }

    public String functionName() {
        return this.functionName;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Integer batchSize() {
        return this.batchSize;
    }

    public String startingPosition() {
        return this.startingPosition;
    }

    public Date startingPositionTimestamp() {
        return this.startingPositionTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.eventSourceArn() == null ? 0 : this.eventSourceArn().hashCode());
        hashCode = 31 * hashCode + (this.functionName() == null ? 0 : this.functionName().hashCode());
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.batchSize() == null ? 0 : this.batchSize().hashCode());
        hashCode = 31 * hashCode + (this.startingPosition() == null ? 0 : this.startingPosition().hashCode());
        hashCode = 31 * hashCode + (this.startingPositionTimestamp() == null ? 0 : this.startingPositionTimestamp().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventSourceMappingRequest)) {
            return false;
        }
        CreateEventSourceMappingRequest other = (CreateEventSourceMappingRequest)((Object)obj);
        if (other.eventSourceArn() == null ^ this.eventSourceArn() == null) {
            return false;
        }
        if (other.eventSourceArn() != null && !other.eventSourceArn().equals(this.eventSourceArn())) {
            return false;
        }
        if (other.functionName() == null ^ this.functionName() == null) {
            return false;
        }
        if (other.functionName() != null && !other.functionName().equals(this.functionName())) {
            return false;
        }
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.batchSize() == null ^ this.batchSize() == null) {
            return false;
        }
        if (other.batchSize() != null && !other.batchSize().equals(this.batchSize())) {
            return false;
        }
        if (other.startingPosition() == null ^ this.startingPosition() == null) {
            return false;
        }
        if (other.startingPosition() != null && !other.startingPosition().equals(this.startingPosition())) {
            return false;
        }
        if (other.startingPositionTimestamp() == null ^ this.startingPositionTimestamp() == null) {
            return false;
        }
        return other.startingPositionTimestamp() == null || other.startingPositionTimestamp().equals(this.startingPositionTimestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.eventSourceArn() != null) {
            sb.append("EventSourceArn: ").append(this.eventSourceArn()).append(",");
        }
        if (this.functionName() != null) {
            sb.append("FunctionName: ").append(this.functionName()).append(",");
        }
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.batchSize() != null) {
            sb.append("BatchSize: ").append(this.batchSize()).append(",");
        }
        if (this.startingPosition() != null) {
            sb.append("StartingPosition: ").append(this.startingPosition()).append(",");
        }
        if (this.startingPositionTimestamp() != null) {
            sb.append("StartingPositionTimestamp: ").append(this.startingPositionTimestamp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String eventSourceArn;
        private String functionName;
        private Boolean enabled;
        private Integer batchSize;
        private String startingPosition;
        private Date startingPositionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventSourceMappingRequest model) {
            this.setEventSourceArn(model.eventSourceArn);
            this.setFunctionName(model.functionName);
            this.setEnabled(model.enabled);
            this.setBatchSize(model.batchSize);
            this.setStartingPosition(model.startingPosition);
            this.setStartingPositionTimestamp(model.startingPositionTimestamp);
        }

        public final String getEventSourceArn() {
            return this.eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        public final String getStartingPosition() {
            return this.startingPosition;
        }

        @Override
        public final Builder startingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        @Override
        public final Builder startingPosition(EventSourcePosition startingPosition) {
            this.startingPosition(startingPosition.toString());
            return this;
        }

        public final void setStartingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
        }

        public final void setStartingPosition(EventSourcePosition startingPosition) {
            this.startingPosition(startingPosition.toString());
        }

        public final Date getStartingPositionTimestamp() {
            return this.startingPositionTimestamp;
        }

        @Override
        public final Builder startingPositionTimestamp(Date startingPositionTimestamp) {
            this.startingPositionTimestamp = StandardMemberCopier.copy((Date)startingPositionTimestamp);
            return this;
        }

        public final void setStartingPositionTimestamp(Date startingPositionTimestamp) {
            this.startingPositionTimestamp = StandardMemberCopier.copy((Date)startingPositionTimestamp);
        }

        public CreateEventSourceMappingRequest build() {
            return new CreateEventSourceMappingRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateEventSourceMappingRequest> {
        public Builder eventSourceArn(String var1);

        public Builder functionName(String var1);

        public Builder enabled(Boolean var1);

        public Builder batchSize(Integer var1);

        public Builder startingPosition(String var1);

        public Builder startingPosition(EventSourcePosition var1);

        public Builder startingPositionTimestamp(Date var1);
    }
}

