/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines an object to add to or delete from a governed table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WriteOperation implements SdkPojo, Serializable, ToCopyableBuilder<WriteOperation.Builder, WriteOperation> {
    private static final SdkField<AddObjectInput> ADD_OBJECT_FIELD = SdkField.<AddObjectInput> builder(MarshallingType.SDK_POJO)
            .memberName("AddObject").getter(getter(WriteOperation::addObject)).setter(setter(Builder::addObject))
            .constructor(AddObjectInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddObject").build()).build();

    private static final SdkField<DeleteObjectInput> DELETE_OBJECT_FIELD = SdkField
            .<DeleteObjectInput> builder(MarshallingType.SDK_POJO).memberName("DeleteObject")
            .getter(getter(WriteOperation::deleteObject)).setter(setter(Builder::deleteObject))
            .constructor(DeleteObjectInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteObject").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_OBJECT_FIELD,
            DELETE_OBJECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AddObjectInput addObject;

    private final DeleteObjectInput deleteObject;

    private WriteOperation(BuilderImpl builder) {
        this.addObject = builder.addObject;
        this.deleteObject = builder.deleteObject;
    }

    /**
     * <p>
     * A new object to add to the governed table.
     * </p>
     * 
     * @return A new object to add to the governed table.
     */
    public final AddObjectInput addObject() {
        return addObject;
    }

    /**
     * <p>
     * An object to delete from the governed table.
     * </p>
     * 
     * @return An object to delete from the governed table.
     */
    public final DeleteObjectInput deleteObject() {
        return deleteObject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addObject());
        hashCode = 31 * hashCode + Objects.hashCode(deleteObject());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteOperation)) {
            return false;
        }
        WriteOperation other = (WriteOperation) obj;
        return Objects.equals(addObject(), other.addObject()) && Objects.equals(deleteObject(), other.deleteObject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WriteOperation").add("AddObject", addObject()).add("DeleteObject", deleteObject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddObject":
            return Optional.ofNullable(clazz.cast(addObject()));
        case "DeleteObject":
            return Optional.ofNullable(clazz.cast(deleteObject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AddObject", ADD_OBJECT_FIELD);
        map.put("DeleteObject", DELETE_OBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WriteOperation, T> g) {
        return obj -> g.apply((WriteOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WriteOperation> {
        /**
         * <p>
         * A new object to add to the governed table.
         * </p>
         * 
         * @param addObject
         *        A new object to add to the governed table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addObject(AddObjectInput addObject);

        /**
         * <p>
         * A new object to add to the governed table.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddObjectInput.Builder} avoiding the need
         * to create one manually via {@link AddObjectInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddObjectInput.Builder#build()} is called immediately and its
         * result is passed to {@link #addObject(AddObjectInput)}.
         * 
         * @param addObject
         *        a consumer that will call methods on {@link AddObjectInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addObject(AddObjectInput)
         */
        default Builder addObject(Consumer<AddObjectInput.Builder> addObject) {
            return addObject(AddObjectInput.builder().applyMutation(addObject).build());
        }

        /**
         * <p>
         * An object to delete from the governed table.
         * </p>
         * 
         * @param deleteObject
         *        An object to delete from the governed table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteObject(DeleteObjectInput deleteObject);

        /**
         * <p>
         * An object to delete from the governed table.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeleteObjectInput.Builder} avoiding the
         * need to create one manually via {@link DeleteObjectInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeleteObjectInput.Builder#build()} is called immediately and its
         * result is passed to {@link #deleteObject(DeleteObjectInput)}.
         * 
         * @param deleteObject
         *        a consumer that will call methods on {@link DeleteObjectInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteObject(DeleteObjectInput)
         */
        default Builder deleteObject(Consumer<DeleteObjectInput.Builder> deleteObject) {
            return deleteObject(DeleteObjectInput.builder().applyMutation(deleteObject).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AddObjectInput addObject;

        private DeleteObjectInput deleteObject;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteOperation model) {
            addObject(model.addObject);
            deleteObject(model.deleteObject);
        }

        public final AddObjectInput.Builder getAddObject() {
            return addObject != null ? addObject.toBuilder() : null;
        }

        public final void setAddObject(AddObjectInput.BuilderImpl addObject) {
            this.addObject = addObject != null ? addObject.build() : null;
        }

        @Override
        public final Builder addObject(AddObjectInput addObject) {
            this.addObject = addObject;
            return this;
        }

        public final DeleteObjectInput.Builder getDeleteObject() {
            return deleteObject != null ? deleteObject.toBuilder() : null;
        }

        public final void setDeleteObject(DeleteObjectInput.BuilderImpl deleteObject) {
            this.deleteObject = deleteObject != null ? deleteObject.build() : null;
        }

        @Override
        public final Builder deleteObject(DeleteObjectInput deleteObject) {
            this.deleteObject = deleteObject;
            return this;
        }

        @Override
        public WriteOperation build() {
            return new WriteOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
