/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A union structure representing different Redshift integration scopes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftScopeUnion implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftScopeUnion.Builder, RedshiftScopeUnion> {
    private static final SdkField<RedshiftConnect> REDSHIFT_CONNECT_FIELD = SdkField
            .<RedshiftConnect> builder(MarshallingType.SDK_POJO).memberName("RedshiftConnect")
            .getter(getter(RedshiftScopeUnion::redshiftConnect)).setter(setter(Builder::redshiftConnect))
            .constructor(RedshiftConnect::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftConnect").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDSHIFT_CONNECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RedshiftConnect redshiftConnect;

    private final Type type;

    private RedshiftScopeUnion(BuilderImpl builder) {
        this.redshiftConnect = builder.redshiftConnect;
        this.type = builder.type;
    }

    /**
     * <p>
     * Configuration for Redshift Connect integration.
     * </p>
     * 
     * @return Configuration for Redshift Connect integration.
     */
    public final RedshiftConnect redshiftConnect() {
        return redshiftConnect;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(redshiftConnect());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftScopeUnion)) {
            return false;
        }
        RedshiftScopeUnion other = (RedshiftScopeUnion) obj;
        return Objects.equals(redshiftConnect(), other.redshiftConnect());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftScopeUnion").add("RedshiftConnect", redshiftConnect()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RedshiftConnect":
            return Optional.ofNullable(clazz.cast(redshiftConnect()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #redshiftConnect()} initialized to the given value.
     *
     * <p>
     * Configuration for Redshift Connect integration.
     * </p>
     * 
     * @param redshiftConnect
     *        Configuration for Redshift Connect integration.
     */
    public static RedshiftScopeUnion fromRedshiftConnect(RedshiftConnect redshiftConnect) {
        return builder().redshiftConnect(redshiftConnect).build();
    }

    /**
     * Create an instance of this class with {@link #redshiftConnect()} initialized to the given value.
     *
     * <p>
     * Configuration for Redshift Connect integration.
     * </p>
     * 
     * @param redshiftConnect
     *        Configuration for Redshift Connect integration.
     */
    public static RedshiftScopeUnion fromRedshiftConnect(Consumer<RedshiftConnect.Builder> redshiftConnect) {
        RedshiftConnect.Builder builder = RedshiftConnect.builder();
        redshiftConnect.accept(builder);
        return fromRedshiftConnect(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RedshiftConnect", REDSHIFT_CONNECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftScopeUnion, T> g) {
        return obj -> g.apply((RedshiftScopeUnion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftScopeUnion> {
        /**
         * <p>
         * Configuration for Redshift Connect integration.
         * </p>
         * 
         * @param redshiftConnect
         *        Configuration for Redshift Connect integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftConnect(RedshiftConnect redshiftConnect);

        /**
         * <p>
         * Configuration for Redshift Connect integration.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftConnect.Builder} avoiding the
         * need to create one manually via {@link RedshiftConnect#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftConnect.Builder#build()} is called immediately and its
         * result is passed to {@link #redshiftConnect(RedshiftConnect)}.
         * 
         * @param redshiftConnect
         *        a consumer that will call methods on {@link RedshiftConnect.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftConnect(RedshiftConnect)
         */
        default Builder redshiftConnect(Consumer<RedshiftConnect.Builder> redshiftConnect) {
            return redshiftConnect(RedshiftConnect.builder().applyMutation(redshiftConnect).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RedshiftConnect redshiftConnect;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftScopeUnion model) {
            redshiftConnect(model.redshiftConnect);
        }

        public final RedshiftConnect.Builder getRedshiftConnect() {
            return redshiftConnect != null ? redshiftConnect.toBuilder() : null;
        }

        public final void setRedshiftConnect(RedshiftConnect.BuilderImpl redshiftConnect) {
            Object oldValue = this.redshiftConnect;
            this.redshiftConnect = redshiftConnect != null ? redshiftConnect.build() : null;
            handleUnionValueChange(Type.REDSHIFT_CONNECT, oldValue, this.redshiftConnect);
        }

        @Override
        public final Builder redshiftConnect(RedshiftConnect redshiftConnect) {
            Object oldValue = this.redshiftConnect;
            this.redshiftConnect = redshiftConnect;
            handleUnionValueChange(Type.REDSHIFT_CONNECT, oldValue, this.redshiftConnect);
            return this;
        }

        @Override
        public RedshiftScopeUnion build() {
            return new RedshiftScopeUnion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RedshiftScopeUnion#type()
     */
    public enum Type {
        REDSHIFT_CONNECT,

        UNKNOWN_TO_SDK_VERSION
    }
}
