/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.PartitionValuesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteObjectInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeleteObjectInput> {
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Uri").getter(DeleteObjectInput.getter(DeleteObjectInput::uri)).setter(DeleteObjectInput.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uri").build()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(DeleteObjectInput.getter(DeleteObjectInput::eTag)).setter(DeleteObjectInput.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()}).build();
    private static final SdkField<List<String>> PARTITION_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartitionValues").getter(DeleteObjectInput.getter(DeleteObjectInput::partitionValues)).setter(DeleteObjectInput.setter(Builder::partitionValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URI_FIELD, E_TAG_FIELD, PARTITION_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteObjectInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String uri;
    private final String eTag;
    private final List<String> partitionValues;

    private DeleteObjectInput(BuilderImpl builder) {
        this.uri = builder.uri;
        this.eTag = builder.eTag;
        this.partitionValues = builder.partitionValues;
    }

    public final String uri() {
        return this.uri;
    }

    public final String eTag() {
        return this.eTag;
    }

    public final boolean hasPartitionValues() {
        return this.partitionValues != null && !(this.partitionValues instanceof SdkAutoConstructList);
    }

    public final List<String> partitionValues() {
        return this.partitionValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionValues() ? this.partitionValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteObjectInput)) {
            return false;
        }
        DeleteObjectInput other = (DeleteObjectInput)obj;
        return Objects.equals(this.uri(), other.uri()) && Objects.equals(this.eTag(), other.eTag()) && this.hasPartitionValues() == other.hasPartitionValues() && Objects.equals(this.partitionValues(), other.partitionValues());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteObjectInput").add("Uri", (Object)this.uri()).add("ETag", (Object)this.eTag()).add("PartitionValues", this.hasPartitionValues() ? this.partitionValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "PartitionValues": {
                return Optional.ofNullable(clazz.cast(this.partitionValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Uri", URI_FIELD);
        map.put("ETag", E_TAG_FIELD);
        map.put("PartitionValues", PARTITION_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteObjectInput, T> g) {
        return obj -> g.apply((DeleteObjectInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String uri;
        private String eTag;
        private List<String> partitionValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteObjectInput model) {
            this.uri(model.uri);
            this.eTag(model.eTag);
            this.partitionValues(model.partitionValues);
        }

        public final String getUri() {
            return this.uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final Collection<String> getPartitionValues() {
            if (this.partitionValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitionValues;
        }

        public final void setPartitionValues(Collection<String> partitionValues) {
            this.partitionValues = PartitionValuesListCopier.copy(partitionValues);
        }

        @Override
        public final Builder partitionValues(Collection<String> partitionValues) {
            this.partitionValues = PartitionValuesListCopier.copy(partitionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionValues(String ... partitionValues) {
            this.partitionValues(Arrays.asList(partitionValues));
            return this;
        }

        public DeleteObjectInput build() {
            return new DeleteObjectInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeleteObjectInput> {
        public Builder uri(String var1);

        public Builder eTag(String var1);

        public Builder partitionValues(Collection<String> var1);

        public Builder partitionValues(String ... var1);
    }
}

