/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.LFTagPair;
import software.amazon.awssdk.services.lakeformation.model.LFTagsListCopier;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.services.lakeformation.model.Resource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddLfTagsToResourceRequest
extends LakeFormationRequest
implements ToCopyableBuilder<Builder, AddLfTagsToResourceRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(AddLfTagsToResourceRequest.getter(AddLfTagsToResourceRequest::catalogId)).setter(AddLfTagsToResourceRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Resource").getter(AddLfTagsToResourceRequest.getter(AddLfTagsToResourceRequest::resource)).setter(AddLfTagsToResourceRequest.setter(Builder::resource)).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()}).build();
    private static final SdkField<List<LFTagPair>> LF_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LFTags").getter(AddLfTagsToResourceRequest.getter(AddLfTagsToResourceRequest::lfTags)).setter(AddLfTagsToResourceRequest.setter(Builder::lfTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LFTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LFTagPair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, RESOURCE_FIELD, LF_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddLfTagsToResourceRequest.memberNameToFieldInitializer();
    private final String catalogId;
    private final Resource resource;
    private final List<LFTagPair> lfTags;

    private AddLfTagsToResourceRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.resource = builder.resource;
        this.lfTags = builder.lfTags;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final Resource resource() {
        return this.resource;
    }

    public final boolean hasLfTags() {
        return this.lfTags != null && !(this.lfTags instanceof SdkAutoConstructList);
    }

    public final List<LFTagPair> lfTags() {
        return this.lfTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLfTags() ? this.lfTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddLfTagsToResourceRequest)) {
            return false;
        }
        AddLfTagsToResourceRequest other = (AddLfTagsToResourceRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.resource(), other.resource()) && this.hasLfTags() == other.hasLfTags() && Objects.equals(this.lfTags(), other.lfTags());
    }

    public final String toString() {
        return ToString.builder((String)"AddLfTagsToResourceRequest").add("CatalogId", (Object)this.catalogId()).add("Resource", (Object)this.resource()).add("LFTags", this.hasLfTags() ? this.lfTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "Resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "LFTags": {
                return Optional.ofNullable(clazz.cast(this.lfTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("Resource", RESOURCE_FIELD);
        map.put("LFTags", LF_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddLfTagsToResourceRequest, T> g) {
        return obj -> g.apply((AddLfTagsToResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private Resource resource;
        private List<LFTagPair> lfTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddLfTagsToResourceRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.resource(model.resource);
            this.lfTags(model.lfTags);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final Resource.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final List<LFTagPair.Builder> getLfTags() {
            List<LFTagPair.Builder> result = LFTagsListCopier.copyToBuilder(this.lfTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLfTags(Collection<LFTagPair.BuilderImpl> lfTags) {
            this.lfTags = LFTagsListCopier.copyFromBuilder(lfTags);
        }

        @Override
        public final Builder lfTags(Collection<LFTagPair> lfTags) {
            this.lfTags = LFTagsListCopier.copy(lfTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lfTags(LFTagPair ... lfTags) {
            this.lfTags(Arrays.asList(lfTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lfTags(Consumer<LFTagPair.Builder> ... lfTags) {
            this.lfTags(Stream.of(lfTags).map(c -> (LFTagPair)((LFTagPair.Builder)LFTagPair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddLfTagsToResourceRequest build() {
            return new AddLfTagsToResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LakeFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddLfTagsToResourceRequest> {
        public Builder catalogId(String var1);

        public Builder resource(Resource var1);

        default public Builder resource(Consumer<Resource.Builder> resource) {
            return this.resource((Resource)((Resource.Builder)Resource.builder().applyMutation(resource)).build());
        }

        public Builder lfTags(Collection<LFTagPair> var1);

        public Builder lfTags(LFTagPair ... var1);

        public Builder lfTags(Consumer<LFTagPair.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

