/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lakeformation.model.CatalogResource;
import software.amazon.awssdk.services.lakeformation.model.DataCellsFilterResource;
import software.amazon.awssdk.services.lakeformation.model.DataLocationResource;
import software.amazon.awssdk.services.lakeformation.model.DatabaseResource;
import software.amazon.awssdk.services.lakeformation.model.LFTagExpressionResource;
import software.amazon.awssdk.services.lakeformation.model.LFTagKeyResource;
import software.amazon.awssdk.services.lakeformation.model.LFTagPolicyResource;
import software.amazon.awssdk.services.lakeformation.model.TableResource;
import software.amazon.awssdk.services.lakeformation.model.TableWithColumnsResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Resource> {
    private static final SdkField<CatalogResource> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Catalog").getter(Resource.getter(Resource::catalog)).setter(Resource.setter(Builder::catalog)).constructor(CatalogResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<DatabaseResource> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Database").getter(Resource.getter(Resource::database)).setter(Resource.setter(Builder::database)).constructor(DatabaseResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<TableResource> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Table").getter(Resource.getter(Resource::table)).setter(Resource.setter(Builder::table)).constructor(TableResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<TableWithColumnsResource> TABLE_WITH_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TableWithColumns").getter(Resource.getter(Resource::tableWithColumns)).setter(Resource.setter(Builder::tableWithColumns)).constructor(TableWithColumnsResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableWithColumns").build()}).build();
    private static final SdkField<DataLocationResource> DATA_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataLocation").getter(Resource.getter(Resource::dataLocation)).setter(Resource.setter(Builder::dataLocation)).constructor(DataLocationResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLocation").build()}).build();
    private static final SdkField<DataCellsFilterResource> DATA_CELLS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataCellsFilter").getter(Resource.getter(Resource::dataCellsFilter)).setter(Resource.setter(Builder::dataCellsFilter)).constructor(DataCellsFilterResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCellsFilter").build()}).build();
    private static final SdkField<LFTagKeyResource> LF_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LFTag").getter(Resource.getter(Resource::lfTag)).setter(Resource.setter(Builder::lfTag)).constructor(LFTagKeyResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LFTag").build()}).build();
    private static final SdkField<LFTagPolicyResource> LF_TAG_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LFTagPolicy").getter(Resource.getter(Resource::lfTagPolicy)).setter(Resource.setter(Builder::lfTagPolicy)).constructor(LFTagPolicyResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LFTagPolicy").build()}).build();
    private static final SdkField<LFTagExpressionResource> LF_TAG_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LFTagExpression").getter(Resource.getter(Resource::lfTagExpression)).setter(Resource.setter(Builder::lfTagExpression)).constructor(LFTagExpressionResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LFTagExpression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, DATABASE_FIELD, TABLE_FIELD, TABLE_WITH_COLUMNS_FIELD, DATA_LOCATION_FIELD, DATA_CELLS_FILTER_FIELD, LF_TAG_FIELD, LF_TAG_POLICY_FIELD, LF_TAG_EXPRESSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Resource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CatalogResource catalog;
    private final DatabaseResource database;
    private final TableResource table;
    private final TableWithColumnsResource tableWithColumns;
    private final DataLocationResource dataLocation;
    private final DataCellsFilterResource dataCellsFilter;
    private final LFTagKeyResource lfTag;
    private final LFTagPolicyResource lfTagPolicy;
    private final LFTagExpressionResource lfTagExpression;

    private Resource(BuilderImpl builder) {
        this.catalog = builder.catalog;
        this.database = builder.database;
        this.table = builder.table;
        this.tableWithColumns = builder.tableWithColumns;
        this.dataLocation = builder.dataLocation;
        this.dataCellsFilter = builder.dataCellsFilter;
        this.lfTag = builder.lfTag;
        this.lfTagPolicy = builder.lfTagPolicy;
        this.lfTagExpression = builder.lfTagExpression;
    }

    public final CatalogResource catalog() {
        return this.catalog;
    }

    public final DatabaseResource database() {
        return this.database;
    }

    public final TableResource table() {
        return this.table;
    }

    public final TableWithColumnsResource tableWithColumns() {
        return this.tableWithColumns;
    }

    public final DataLocationResource dataLocation() {
        return this.dataLocation;
    }

    public final DataCellsFilterResource dataCellsFilter() {
        return this.dataCellsFilter;
    }

    public final LFTagKeyResource lfTag() {
        return this.lfTag;
    }

    public final LFTagPolicyResource lfTagPolicy() {
        return this.lfTagPolicy;
    }

    public final LFTagExpressionResource lfTagExpression() {
        return this.lfTagExpression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableWithColumns());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCellsFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.lfTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.lfTagPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lfTagExpression());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.tableWithColumns(), other.tableWithColumns()) && Objects.equals(this.dataLocation(), other.dataLocation()) && Objects.equals(this.dataCellsFilter(), other.dataCellsFilter()) && Objects.equals(this.lfTag(), other.lfTag()) && Objects.equals(this.lfTagPolicy(), other.lfTagPolicy()) && Objects.equals(this.lfTagExpression(), other.lfTagExpression());
    }

    public final String toString() {
        return ToString.builder((String)"Resource").add("Catalog", (Object)this.catalog()).add("Database", (Object)this.database()).add("Table", (Object)this.table()).add("TableWithColumns", (Object)this.tableWithColumns()).add("DataLocation", (Object)this.dataLocation()).add("DataCellsFilter", (Object)this.dataCellsFilter()).add("LFTag", (Object)this.lfTag()).add("LFTagPolicy", (Object)this.lfTagPolicy()).add("LFTagExpression", (Object)this.lfTagExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "TableWithColumns": {
                return Optional.ofNullable(clazz.cast(this.tableWithColumns()));
            }
            case "DataLocation": {
                return Optional.ofNullable(clazz.cast(this.dataLocation()));
            }
            case "DataCellsFilter": {
                return Optional.ofNullable(clazz.cast(this.dataCellsFilter()));
            }
            case "LFTag": {
                return Optional.ofNullable(clazz.cast(this.lfTag()));
            }
            case "LFTagPolicy": {
                return Optional.ofNullable(clazz.cast(this.lfTagPolicy()));
            }
            case "LFTagExpression": {
                return Optional.ofNullable(clazz.cast(this.lfTagExpression()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("Table", TABLE_FIELD);
        map.put("TableWithColumns", TABLE_WITH_COLUMNS_FIELD);
        map.put("DataLocation", DATA_LOCATION_FIELD);
        map.put("DataCellsFilter", DATA_CELLS_FILTER_FIELD);
        map.put("LFTag", LF_TAG_FIELD);
        map.put("LFTagPolicy", LF_TAG_POLICY_FIELD);
        map.put("LFTagExpression", LF_TAG_EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CatalogResource catalog;
        private DatabaseResource database;
        private TableResource table;
        private TableWithColumnsResource tableWithColumns;
        private DataLocationResource dataLocation;
        private DataCellsFilterResource dataCellsFilter;
        private LFTagKeyResource lfTag;
        private LFTagPolicyResource lfTagPolicy;
        private LFTagExpressionResource lfTagExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            this.catalog(model.catalog);
            this.database(model.database);
            this.table(model.table);
            this.tableWithColumns(model.tableWithColumns);
            this.dataLocation(model.dataLocation);
            this.dataCellsFilter(model.dataCellsFilter);
            this.lfTag(model.lfTag);
            this.lfTagPolicy(model.lfTagPolicy);
            this.lfTagExpression(model.lfTagExpression);
        }

        public final CatalogResource.Builder getCatalog() {
            return this.catalog != null ? this.catalog.toBuilder() : null;
        }

        public final void setCatalog(CatalogResource.BuilderImpl catalog) {
            this.catalog = catalog != null ? catalog.build() : null;
        }

        @Override
        public final Builder catalog(CatalogResource catalog) {
            this.catalog = catalog;
            return this;
        }

        public final DatabaseResource.Builder getDatabase() {
            return this.database != null ? this.database.toBuilder() : null;
        }

        public final void setDatabase(DatabaseResource.BuilderImpl database) {
            this.database = database != null ? database.build() : null;
        }

        @Override
        public final Builder database(DatabaseResource database) {
            this.database = database;
            return this;
        }

        public final TableResource.Builder getTable() {
            return this.table != null ? this.table.toBuilder() : null;
        }

        public final void setTable(TableResource.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        @Override
        public final Builder table(TableResource table) {
            this.table = table;
            return this;
        }

        public final TableWithColumnsResource.Builder getTableWithColumns() {
            return this.tableWithColumns != null ? this.tableWithColumns.toBuilder() : null;
        }

        public final void setTableWithColumns(TableWithColumnsResource.BuilderImpl tableWithColumns) {
            this.tableWithColumns = tableWithColumns != null ? tableWithColumns.build() : null;
        }

        @Override
        public final Builder tableWithColumns(TableWithColumnsResource tableWithColumns) {
            this.tableWithColumns = tableWithColumns;
            return this;
        }

        public final DataLocationResource.Builder getDataLocation() {
            return this.dataLocation != null ? this.dataLocation.toBuilder() : null;
        }

        public final void setDataLocation(DataLocationResource.BuilderImpl dataLocation) {
            this.dataLocation = dataLocation != null ? dataLocation.build() : null;
        }

        @Override
        public final Builder dataLocation(DataLocationResource dataLocation) {
            this.dataLocation = dataLocation;
            return this;
        }

        public final DataCellsFilterResource.Builder getDataCellsFilter() {
            return this.dataCellsFilter != null ? this.dataCellsFilter.toBuilder() : null;
        }

        public final void setDataCellsFilter(DataCellsFilterResource.BuilderImpl dataCellsFilter) {
            this.dataCellsFilter = dataCellsFilter != null ? dataCellsFilter.build() : null;
        }

        @Override
        public final Builder dataCellsFilter(DataCellsFilterResource dataCellsFilter) {
            this.dataCellsFilter = dataCellsFilter;
            return this;
        }

        public final LFTagKeyResource.Builder getLfTag() {
            return this.lfTag != null ? this.lfTag.toBuilder() : null;
        }

        public final void setLfTag(LFTagKeyResource.BuilderImpl lfTag) {
            this.lfTag = lfTag != null ? lfTag.build() : null;
        }

        @Override
        public final Builder lfTag(LFTagKeyResource lfTag) {
            this.lfTag = lfTag;
            return this;
        }

        public final LFTagPolicyResource.Builder getLfTagPolicy() {
            return this.lfTagPolicy != null ? this.lfTagPolicy.toBuilder() : null;
        }

        public final void setLfTagPolicy(LFTagPolicyResource.BuilderImpl lfTagPolicy) {
            this.lfTagPolicy = lfTagPolicy != null ? lfTagPolicy.build() : null;
        }

        @Override
        public final Builder lfTagPolicy(LFTagPolicyResource lfTagPolicy) {
            this.lfTagPolicy = lfTagPolicy;
            return this;
        }

        public final LFTagExpressionResource.Builder getLfTagExpression() {
            return this.lfTagExpression != null ? this.lfTagExpression.toBuilder() : null;
        }

        public final void setLfTagExpression(LFTagExpressionResource.BuilderImpl lfTagExpression) {
            this.lfTagExpression = lfTagExpression != null ? lfTagExpression.build() : null;
        }

        @Override
        public final Builder lfTagExpression(LFTagExpressionResource lfTagExpression) {
            this.lfTagExpression = lfTagExpression;
            return this;
        }

        public Resource build() {
            return new Resource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Resource> {
        public Builder catalog(CatalogResource var1);

        default public Builder catalog(Consumer<CatalogResource.Builder> catalog) {
            return this.catalog((CatalogResource)((CatalogResource.Builder)CatalogResource.builder().applyMutation(catalog)).build());
        }

        public Builder database(DatabaseResource var1);

        default public Builder database(Consumer<DatabaseResource.Builder> database) {
            return this.database((DatabaseResource)((DatabaseResource.Builder)DatabaseResource.builder().applyMutation(database)).build());
        }

        public Builder table(TableResource var1);

        default public Builder table(Consumer<TableResource.Builder> table) {
            return this.table((TableResource)((TableResource.Builder)TableResource.builder().applyMutation(table)).build());
        }

        public Builder tableWithColumns(TableWithColumnsResource var1);

        default public Builder tableWithColumns(Consumer<TableWithColumnsResource.Builder> tableWithColumns) {
            return this.tableWithColumns((TableWithColumnsResource)((TableWithColumnsResource.Builder)TableWithColumnsResource.builder().applyMutation(tableWithColumns)).build());
        }

        public Builder dataLocation(DataLocationResource var1);

        default public Builder dataLocation(Consumer<DataLocationResource.Builder> dataLocation) {
            return this.dataLocation((DataLocationResource)((DataLocationResource.Builder)DataLocationResource.builder().applyMutation(dataLocation)).build());
        }

        public Builder dataCellsFilter(DataCellsFilterResource var1);

        default public Builder dataCellsFilter(Consumer<DataCellsFilterResource.Builder> dataCellsFilter) {
            return this.dataCellsFilter((DataCellsFilterResource)((DataCellsFilterResource.Builder)DataCellsFilterResource.builder().applyMutation(dataCellsFilter)).build());
        }

        public Builder lfTag(LFTagKeyResource var1);

        default public Builder lfTag(Consumer<LFTagKeyResource.Builder> lfTag) {
            return this.lfTag((LFTagKeyResource)((LFTagKeyResource.Builder)LFTagKeyResource.builder().applyMutation(lfTag)).build());
        }

        public Builder lfTagPolicy(LFTagPolicyResource var1);

        default public Builder lfTagPolicy(Consumer<LFTagPolicyResource.Builder> lfTagPolicy) {
            return this.lfTagPolicy((LFTagPolicyResource)((LFTagPolicyResource.Builder)LFTagPolicyResource.builder().applyMutation(lfTagPolicy)).build());
        }

        public Builder lfTagExpression(LFTagExpressionResource var1);

        default public Builder lfTagExpression(Consumer<LFTagExpressionResource.Builder> lfTagExpression) {
            return this.lfTagExpression((LFTagExpressionResource)((LFTagExpressionResource.Builder)LFTagExpressionResource.builder().applyMutation(lfTagExpression)).build());
        }
    }
}

