/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssumeDecoratedRoleWithSamlRequest
extends LakeFormationRequest
implements ToCopyableBuilder<Builder, AssumeDecoratedRoleWithSamlRequest> {
    private static final SdkField<String> SAML_ASSERTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SAMLAssertion").getter(AssumeDecoratedRoleWithSamlRequest.getter(AssumeDecoratedRoleWithSamlRequest::samlAssertion)).setter(AssumeDecoratedRoleWithSamlRequest.setter(Builder::samlAssertion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLAssertion").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(AssumeDecoratedRoleWithSamlRequest.getter(AssumeDecoratedRoleWithSamlRequest::roleArn)).setter(AssumeDecoratedRoleWithSamlRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrincipalArn").getter(AssumeDecoratedRoleWithSamlRequest.getter(AssumeDecoratedRoleWithSamlRequest::principalArn)).setter(AssumeDecoratedRoleWithSamlRequest.setter(Builder::principalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalArn").build()}).build();
    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DurationSeconds").getter(AssumeDecoratedRoleWithSamlRequest.getter(AssumeDecoratedRoleWithSamlRequest::durationSeconds)).setter(AssumeDecoratedRoleWithSamlRequest.setter(Builder::durationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_ASSERTION_FIELD, ROLE_ARN_FIELD, PRINCIPAL_ARN_FIELD, DURATION_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssumeDecoratedRoleWithSamlRequest.memberNameToFieldInitializer();
    private final String samlAssertion;
    private final String roleArn;
    private final String principalArn;
    private final Integer durationSeconds;

    private AssumeDecoratedRoleWithSamlRequest(BuilderImpl builder) {
        super(builder);
        this.samlAssertion = builder.samlAssertion;
        this.roleArn = builder.roleArn;
        this.principalArn = builder.principalArn;
        this.durationSeconds = builder.durationSeconds;
    }

    public final String samlAssertion() {
        return this.samlAssertion;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String principalArn() {
        return this.principalArn;
    }

    public final Integer durationSeconds() {
        return this.durationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.samlAssertion());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeDecoratedRoleWithSamlRequest)) {
            return false;
        }
        AssumeDecoratedRoleWithSamlRequest other = (AssumeDecoratedRoleWithSamlRequest)((Object)obj);
        return Objects.equals(this.samlAssertion(), other.samlAssertion()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.principalArn(), other.principalArn()) && Objects.equals(this.durationSeconds(), other.durationSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"AssumeDecoratedRoleWithSamlRequest").add("SAMLAssertion", (Object)this.samlAssertion()).add("RoleArn", (Object)this.roleArn()).add("PrincipalArn", (Object)this.principalArn()).add("DurationSeconds", (Object)this.durationSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SAMLAssertion": {
                return Optional.ofNullable(clazz.cast(this.samlAssertion()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "PrincipalArn": {
                return Optional.ofNullable(clazz.cast(this.principalArn()));
            }
            case "DurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SAMLAssertion", SAML_ASSERTION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("PrincipalArn", PRINCIPAL_ARN_FIELD);
        map.put("DurationSeconds", DURATION_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssumeDecoratedRoleWithSamlRequest, T> g) {
        return obj -> g.apply((AssumeDecoratedRoleWithSamlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationRequest.BuilderImpl
    implements Builder {
        private String samlAssertion;
        private String roleArn;
        private String principalArn;
        private Integer durationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeDecoratedRoleWithSamlRequest model) {
            super(model);
            this.samlAssertion(model.samlAssertion);
            this.roleArn(model.roleArn);
            this.principalArn(model.principalArn);
            this.durationSeconds(model.durationSeconds);
        }

        public final String getSamlAssertion() {
            return this.samlAssertion;
        }

        public final void setSamlAssertion(String samlAssertion) {
            this.samlAssertion = samlAssertion;
        }

        @Override
        public final Builder samlAssertion(String samlAssertion) {
            this.samlAssertion = samlAssertion;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getPrincipalArn() {
            return this.principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssumeDecoratedRoleWithSamlRequest build() {
            return new AssumeDecoratedRoleWithSamlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LakeFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssumeDecoratedRoleWithSamlRequest> {
        public Builder samlAssertion(String var1);

        public Builder roleArn(String var1);

        public Builder principalArn(String var1);

        public Builder durationSeconds(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

