/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.LFTagPair;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse;

public class ListLFTagsIterable
implements SdkIterable<ListLfTagsResponse> {
    private final LakeFormationClient client;
    private final ListLfTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLFTagsIterable(LakeFormationClient client, ListLfTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLfTagsResponseFetcher();
    }

    public Iterator<ListLfTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LFTagPair> lfTags() {
        Function<ListLfTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.lfTags() != null) {
                return response.lfTags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLfTagsResponseFetcher
    implements SyncPageFetcher<ListLfTagsResponse> {
        private ListLfTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListLfTagsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLfTagsResponse nextPage(ListLfTagsResponse previousPage) {
            if (previousPage == null) {
                return ListLFTagsIterable.this.client.listLFTags(ListLFTagsIterable.this.firstRequest);
            }
            return ListLFTagsIterable.this.client.listLFTags((ListLfTagsRequest)((Object)ListLFTagsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

