/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lakeformation.model.DataCellsFilter;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataCellsFilterRequest
extends LakeFormationRequest
implements ToCopyableBuilder<Builder, CreateDataCellsFilterRequest> {
    private static final SdkField<DataCellsFilter> TABLE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TableData").getter(CreateDataCellsFilterRequest.getter(CreateDataCellsFilterRequest::tableData)).setter(CreateDataCellsFilterRequest.setter(Builder::tableData)).constructor(DataCellsFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_DATA_FIELD));
    private final DataCellsFilter tableData;

    private CreateDataCellsFilterRequest(BuilderImpl builder) {
        super(builder);
        this.tableData = builder.tableData;
    }

    public final DataCellsFilter tableData() {
        return this.tableData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataCellsFilterRequest)) {
            return false;
        }
        CreateDataCellsFilterRequest other = (CreateDataCellsFilterRequest)((Object)obj);
        return Objects.equals(this.tableData(), other.tableData());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataCellsFilterRequest").add("TableData", (Object)this.tableData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableData": {
                return Optional.ofNullable(clazz.cast(this.tableData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataCellsFilterRequest, T> g) {
        return obj -> g.apply((CreateDataCellsFilterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationRequest.BuilderImpl
    implements Builder {
        private DataCellsFilter tableData;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataCellsFilterRequest model) {
            super(model);
            this.tableData(model.tableData);
        }

        public final DataCellsFilter.Builder getTableData() {
            return this.tableData != null ? this.tableData.toBuilder() : null;
        }

        public final void setTableData(DataCellsFilter.BuilderImpl tableData) {
            this.tableData = tableData != null ? tableData.build() : null;
        }

        @Override
        public final Builder tableData(DataCellsFilter tableData) {
            this.tableData = tableData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataCellsFilterRequest build() {
            return new CreateDataCellsFilterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LakeFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataCellsFilterRequest> {
        public Builder tableData(DataCellsFilter var1);

        default public Builder tableData(Consumer<DataCellsFilter.Builder> tableData) {
            return this.tableData((DataCellsFilter)((DataCellsFilter.Builder)DataCellsFilter.builder().applyMutation(tableData)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

