/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lakeformation.model.ExternalFilteringConfiguration;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLakeFormationIdentityCenterConfigurationResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, DescribeLakeFormationIdentityCenterConfigurationResponse> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(DescribeLakeFormationIdentityCenterConfigurationResponse.getter(DescribeLakeFormationIdentityCenterConfigurationResponse::catalogId)).setter(DescribeLakeFormationIdentityCenterConfigurationResponse.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceArn").getter(DescribeLakeFormationIdentityCenterConfigurationResponse.getter(DescribeLakeFormationIdentityCenterConfigurationResponse::instanceArn)).setter(DescribeLakeFormationIdentityCenterConfigurationResponse.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationArn").getter(DescribeLakeFormationIdentityCenterConfigurationResponse.getter(DescribeLakeFormationIdentityCenterConfigurationResponse::applicationArn)).setter(DescribeLakeFormationIdentityCenterConfigurationResponse.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()}).build();
    private static final SdkField<ExternalFilteringConfiguration> EXTERNAL_FILTERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExternalFiltering").getter(DescribeLakeFormationIdentityCenterConfigurationResponse.getter(DescribeLakeFormationIdentityCenterConfigurationResponse::externalFiltering)).setter(DescribeLakeFormationIdentityCenterConfigurationResponse.setter(Builder::externalFiltering)).constructor(ExternalFilteringConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalFiltering").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, INSTANCE_ARN_FIELD, APPLICATION_ARN_FIELD, EXTERNAL_FILTERING_FIELD));
    private final String catalogId;
    private final String instanceArn;
    private final String applicationArn;
    private final ExternalFilteringConfiguration externalFiltering;

    private DescribeLakeFormationIdentityCenterConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.instanceArn = builder.instanceArn;
        this.applicationArn = builder.applicationArn;
        this.externalFiltering = builder.externalFiltering;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final ExternalFilteringConfiguration externalFiltering() {
        return this.externalFiltering;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalFiltering());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLakeFormationIdentityCenterConfigurationResponse)) {
            return false;
        }
        DescribeLakeFormationIdentityCenterConfigurationResponse other = (DescribeLakeFormationIdentityCenterConfigurationResponse)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.externalFiltering(), other.externalFiltering());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLakeFormationIdentityCenterConfigurationResponse").add("CatalogId", (Object)this.catalogId()).add("InstanceArn", (Object)this.instanceArn()).add("ApplicationArn", (Object)this.applicationArn()).add("ExternalFiltering", (Object)this.externalFiltering()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "InstanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "ExternalFiltering": {
                return Optional.ofNullable(clazz.cast(this.externalFiltering()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLakeFormationIdentityCenterConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeLakeFormationIdentityCenterConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private String catalogId;
        private String instanceArn;
        private String applicationArn;
        private ExternalFilteringConfiguration externalFiltering;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLakeFormationIdentityCenterConfigurationResponse model) {
            super(model);
            this.catalogId(model.catalogId);
            this.instanceArn(model.instanceArn);
            this.applicationArn(model.applicationArn);
            this.externalFiltering(model.externalFiltering);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final ExternalFilteringConfiguration.Builder getExternalFiltering() {
            return this.externalFiltering != null ? this.externalFiltering.toBuilder() : null;
        }

        public final void setExternalFiltering(ExternalFilteringConfiguration.BuilderImpl externalFiltering) {
            this.externalFiltering = externalFiltering != null ? externalFiltering.build() : null;
        }

        @Override
        public final Builder externalFiltering(ExternalFilteringConfiguration externalFiltering) {
            this.externalFiltering = externalFiltering;
            return this;
        }

        @Override
        public DescribeLakeFormationIdentityCenterConfigurationResponse build() {
            return new DescribeLakeFormationIdentityCenterConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLakeFormationIdentityCenterConfigurationResponse> {
        public Builder catalogId(String var1);

        public Builder instanceArn(String var1);

        public Builder applicationArn(String var1);

        public Builder externalFiltering(ExternalFilteringConfiguration var1);

        default public Builder externalFiltering(Consumer<ExternalFilteringConfiguration.Builder> externalFiltering) {
            return this.externalFiltering((ExternalFilteringConfiguration)((ExternalFilteringConfiguration.Builder)ExternalFilteringConfiguration.builder().applyMutation(externalFiltering)).build());
        }
    }
}

