/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse;

public class ListTransactionsIterable
implements SdkIterable<ListTransactionsResponse> {
    private final LakeFormationClient client;
    private final ListTransactionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTransactionsIterable(LakeFormationClient client, ListTransactionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTransactionsResponseFetcher();
    }

    public Iterator<ListTransactionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTransactionsResponseFetcher
    implements SyncPageFetcher<ListTransactionsResponse> {
        private ListTransactionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTransactionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTransactionsResponse nextPage(ListTransactionsResponse previousPage) {
            if (previousPage == null) {
                return ListTransactionsIterable.this.client.listTransactions(ListTransactionsIterable.this.firstRequest);
            }
            return ListTransactionsIterable.this.client.listTransactions((ListTransactionsRequest)((Object)ListTransactionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

