/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.FilterCondition;
import software.amazon.awssdk.services.lakeformation.model.FilterConditionListCopier;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourcesRequest
extends LakeFormationRequest
implements ToCopyableBuilder<Builder, ListResourcesRequest> {
    private static final SdkField<List<FilterCondition>> FILTER_CONDITION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterConditionList").getter(ListResourcesRequest.getter(ListResourcesRequest::filterConditionList)).setter(ListResourcesRequest.setter(Builder::filterConditionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterConditionList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListResourcesRequest.getter(ListResourcesRequest::maxResults)).setter(ListResourcesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourcesRequest.getter(ListResourcesRequest::nextToken)).setter(ListResourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CONDITION_LIST_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<FilterCondition> filterConditionList;
    private final Integer maxResults;
    private final String nextToken;

    private ListResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.filterConditionList = builder.filterConditionList;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public boolean hasFilterConditionList() {
        return this.filterConditionList != null && !(this.filterConditionList instanceof SdkAutoConstructList);
    }

    public List<FilterCondition> filterConditionList() {
        return this.filterConditionList;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterConditionList() ? this.filterConditionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesRequest)) {
            return false;
        }
        ListResourcesRequest other = (ListResourcesRequest)((Object)obj);
        return this.hasFilterConditionList() == other.hasFilterConditionList() && Objects.equals(this.filterConditionList(), other.filterConditionList()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListResourcesRequest").add("FilterConditionList", this.hasFilterConditionList() ? this.filterConditionList() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterConditionList": {
                return Optional.ofNullable(clazz.cast(this.filterConditionList()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesRequest, T> g) {
        return obj -> g.apply((ListResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationRequest.BuilderImpl
    implements Builder {
        private List<FilterCondition> filterConditionList = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesRequest model) {
            super(model);
            this.filterConditionList(model.filterConditionList);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<FilterCondition.Builder> getFilterConditionList() {
            if (this.filterConditionList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterConditionList != null ? (Collection)this.filterConditionList.stream().map(FilterCondition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filterConditionList(Collection<FilterCondition> filterConditionList) {
            this.filterConditionList = FilterConditionListCopier.copy(filterConditionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterConditionList(FilterCondition ... filterConditionList) {
            this.filterConditionList(Arrays.asList(filterConditionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterConditionList(Consumer<FilterCondition.Builder> ... filterConditionList) {
            this.filterConditionList(Stream.of(filterConditionList).map(c -> (FilterCondition)((FilterCondition.Builder)FilterCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilterConditionList(Collection<FilterCondition.BuilderImpl> filterConditionList) {
            this.filterConditionList = FilterConditionListCopier.copyFromBuilder(filterConditionList);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourcesRequest build() {
            return new ListResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LakeFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourcesRequest> {
        public Builder filterConditionList(Collection<FilterCondition> var1);

        public Builder filterConditionList(FilterCondition ... var1);

        public Builder filterConditionList(Consumer<FilterCondition.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

