/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissions;
import software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEffectivePermissionsForPathResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, GetEffectivePermissionsForPathResponse> {
    private static final SdkField<List<PrincipalResourcePermissions>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(GetEffectivePermissionsForPathResponse.getter(GetEffectivePermissionsForPathResponse::permissions)).setter(GetEffectivePermissionsForPathResponse.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrincipalResourcePermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetEffectivePermissionsForPathResponse.getter(GetEffectivePermissionsForPathResponse::nextToken)).setter(GetEffectivePermissionsForPathResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<PrincipalResourcePermissions> permissions;
    private final String nextToken;

    private GetEffectivePermissionsForPathResponse(BuilderImpl builder) {
        super(builder);
        this.permissions = builder.permissions;
        this.nextToken = builder.nextToken;
    }

    public boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public List<PrincipalResourcePermissions> permissions() {
        return this.permissions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.permissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEffectivePermissionsForPathResponse)) {
            return false;
        }
        GetEffectivePermissionsForPathResponse other = (GetEffectivePermissionsForPathResponse)((Object)obj);
        return Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetEffectivePermissionsForPathResponse").add("Permissions", this.permissions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEffectivePermissionsForPathResponse, T> g) {
        return obj -> g.apply((GetEffectivePermissionsForPathResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private List<PrincipalResourcePermissions> permissions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEffectivePermissionsForPathResponse model) {
            super(model);
            this.permissions(model.permissions);
            this.nextToken(model.nextToken);
        }

        public final Collection<PrincipalResourcePermissions.Builder> getPermissions() {
            return this.permissions != null ? (Collection)this.permissions.stream().map(PrincipalResourcePermissions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder permissions(Collection<PrincipalResourcePermissions> permissions) {
            this.permissions = PrincipalResourcePermissionsListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(PrincipalResourcePermissions ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<PrincipalResourcePermissions.Builder> ... permissions) {
            this.permissions(Stream.of(permissions).map(c -> (PrincipalResourcePermissions)((PrincipalResourcePermissions.Builder)PrincipalResourcePermissions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPermissions(Collection<PrincipalResourcePermissions.BuilderImpl> permissions) {
            this.permissions = PrincipalResourcePermissionsListCopier.copyFromBuilder(permissions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetEffectivePermissionsForPathResponse build() {
            return new GetEffectivePermissionsForPathResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEffectivePermissionsForPathResponse> {
        public Builder permissions(Collection<PrincipalResourcePermissions> var1);

        public Builder permissions(PrincipalResourcePermissions ... var1);

        public Builder permissions(Consumer<PrincipalResourcePermissions.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

