/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lakeformation.model.DataLakeSettings;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDataLakeSettingsRequest
extends LakeFormationRequest
implements ToCopyableBuilder<Builder, PutDataLakeSettingsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutDataLakeSettingsRequest.getter(PutDataLakeSettingsRequest::catalogId)).setter(PutDataLakeSettingsRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<DataLakeSettings> DATA_LAKE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutDataLakeSettingsRequest.getter(PutDataLakeSettingsRequest::dataLakeSettings)).setter(PutDataLakeSettingsRequest.setter(Builder::dataLakeSettings)).constructor(DataLakeSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATA_LAKE_SETTINGS_FIELD));
    private final String catalogId;
    private final DataLakeSettings dataLakeSettings;

    private PutDataLakeSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.dataLakeSettings = builder.dataLakeSettings;
    }

    public String catalogId() {
        return this.catalogId;
    }

    public DataLakeSettings dataLakeSettings() {
        return this.dataLakeSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLakeSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDataLakeSettingsRequest)) {
            return false;
        }
        PutDataLakeSettingsRequest other = (PutDataLakeSettingsRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.dataLakeSettings(), other.dataLakeSettings());
    }

    public String toString() {
        return ToString.builder((String)"PutDataLakeSettingsRequest").add("CatalogId", (Object)this.catalogId()).add("DataLakeSettings", (Object)this.dataLakeSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DataLakeSettings": {
                return Optional.ofNullable(clazz.cast(this.dataLakeSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDataLakeSettingsRequest, T> g) {
        return obj -> g.apply((PutDataLakeSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private DataLakeSettings dataLakeSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDataLakeSettingsRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.dataLakeSettings(model.dataLakeSettings);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final DataLakeSettings.Builder getDataLakeSettings() {
            return this.dataLakeSettings != null ? this.dataLakeSettings.toBuilder() : null;
        }

        @Override
        public final Builder dataLakeSettings(DataLakeSettings dataLakeSettings) {
            this.dataLakeSettings = dataLakeSettings;
            return this;
        }

        public final void setDataLakeSettings(DataLakeSettings.BuilderImpl dataLakeSettings) {
            this.dataLakeSettings = dataLakeSettings != null ? dataLakeSettings.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDataLakeSettingsRequest build() {
            return new PutDataLakeSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LakeFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDataLakeSettingsRequest> {
        public Builder catalogId(String var1);

        public Builder dataLakeSettings(DataLakeSettings var1);

        default public Builder dataLakeSettings(Consumer<DataLakeSettings.Builder> dataLakeSettings) {
            return this.dataLakeSettings((DataLakeSettings)((DataLakeSettings.Builder)DataLakeSettings.builder().applyMutation(dataLakeSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

