/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DataKeySpec {
    AES_256("AES_256"),
    AES_128("AES_128"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DataKeySpec(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataKeySpec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DataKeySpec.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataKeySpec> knownValues() {
        return Stream.of(DataKeySpec.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

