/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.kms.KmsAsyncClient;
import software.amazon.awssdk.services.kms.internal.UserAgentUtils;
import software.amazon.awssdk.services.kms.model.CustomKeyStoresListEntry;
import software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresRequest;
import software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresResponse;

public class DescribeCustomKeyStoresPublisher
implements SdkPublisher<DescribeCustomKeyStoresResponse> {
    private final KmsAsyncClient client;
    private final DescribeCustomKeyStoresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCustomKeyStoresPublisher(KmsAsyncClient client, DescribeCustomKeyStoresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCustomKeyStoresPublisher(KmsAsyncClient client, DescribeCustomKeyStoresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCustomKeyStoresResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCustomKeyStoresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CustomKeyStoresListEntry> customKeyStores() {
        return this.flatMapIterable(response -> response.customKeyStores());
    }

    private class DescribeCustomKeyStoresResponseFetcher
    implements AsyncPageFetcher<DescribeCustomKeyStoresResponse> {
        private DescribeCustomKeyStoresResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCustomKeyStoresResponse previousPage) {
            return previousPage.truncated() != null && previousPage.truncated() != false;
        }

        public CompletableFuture<DescribeCustomKeyStoresResponse> nextPage(DescribeCustomKeyStoresResponse previousPage) {
            if (previousPage == null) {
                return DescribeCustomKeyStoresPublisher.this.client.describeCustomKeyStores(DescribeCustomKeyStoresPublisher.this.firstRequest);
            }
            return DescribeCustomKeyStoresPublisher.this.client.describeCustomKeyStores((DescribeCustomKeyStoresRequest)((Object)DescribeCustomKeyStoresPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

