/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImportState {
    IMPORTED("IMPORTED"),
    PENDING_IMPORT("PENDING_IMPORT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImportState> VALUE_MAP;
    private final String value;

    private ImportState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImportState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImportState> knownValues() {
        EnumSet<ImportState> knownValues = EnumSet.allOf(ImportState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImportState.class, ImportState::toString);
    }
}

