/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.ExpirationModelType;
import software.amazon.awssdk.services.kms.model.KeyManagerType;
import software.amazon.awssdk.services.kms.model.KeyState;
import software.amazon.awssdk.services.kms.model.KeyUsageType;
import software.amazon.awssdk.services.kms.model.OriginType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyMetadata> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KeyMetadata.getter(KeyMetadata::awsAccountId)).setter(KeyMetadata.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSAccountId").build()}).build();
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KeyMetadata.getter(KeyMetadata::keyId)).setter(KeyMetadata.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KeyMetadata.getter(KeyMetadata::arn)).setter(KeyMetadata.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(KeyMetadata.getter(KeyMetadata::creationDate)).setter(KeyMetadata.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(KeyMetadata.getter(KeyMetadata::enabled)).setter(KeyMetadata.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KeyMetadata.getter(KeyMetadata::description)).setter(KeyMetadata.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> KEY_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KeyMetadata.getter(KeyMetadata::keyUsageAsString)).setter(KeyMetadata.setter(Builder::keyUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyUsage").build()}).build();
    private static final SdkField<String> KEY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KeyMetadata.getter(KeyMetadata::keyStateAsString)).setter(KeyMetadata.setter(Builder::keyState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyState").build()}).build();
    private static final SdkField<Instant> DELETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(KeyMetadata.getter(KeyMetadata::deletionDate)).setter(KeyMetadata.setter(Builder::deletionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionDate").build()}).build();
    private static final SdkField<Instant> VALID_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(KeyMetadata.getter(KeyMetadata::validTo)).setter(KeyMetadata.setter(Builder::validTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidTo").build()}).build();
    private static final SdkField<String> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KeyMetadata.getter(KeyMetadata::originAsString)).setter(KeyMetadata.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()}).build();
    private static final SdkField<String> CUSTOM_KEY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KeyMetadata.getter(KeyMetadata::customKeyStoreId)).setter(KeyMetadata.setter(Builder::customKeyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomKeyStoreId").build()}).build();
    private static final SdkField<String> CLOUD_HSM_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KeyMetadata.getter(KeyMetadata::cloudHsmClusterId)).setter(KeyMetadata.setter(Builder::cloudHsmClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudHsmClusterId").build()}).build();
    private static final SdkField<String> EXPIRATION_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KeyMetadata.getter(KeyMetadata::expirationModelAsString)).setter(KeyMetadata.setter(Builder::expirationModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationModel").build()}).build();
    private static final SdkField<String> KEY_MANAGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KeyMetadata.getter(KeyMetadata::keyManagerAsString)).setter(KeyMetadata.setter(Builder::keyManager)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyManager").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, KEY_ID_FIELD, ARN_FIELD, CREATION_DATE_FIELD, ENABLED_FIELD, DESCRIPTION_FIELD, KEY_USAGE_FIELD, KEY_STATE_FIELD, DELETION_DATE_FIELD, VALID_TO_FIELD, ORIGIN_FIELD, CUSTOM_KEY_STORE_ID_FIELD, CLOUD_HSM_CLUSTER_ID_FIELD, EXPIRATION_MODEL_FIELD, KEY_MANAGER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String awsAccountId;
    private final String keyId;
    private final String arn;
    private final Instant creationDate;
    private final Boolean enabled;
    private final String description;
    private final String keyUsage;
    private final String keyState;
    private final Instant deletionDate;
    private final Instant validTo;
    private final String origin;
    private final String customKeyStoreId;
    private final String cloudHsmClusterId;
    private final String expirationModel;
    private final String keyManager;

    private KeyMetadata(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.keyId = builder.keyId;
        this.arn = builder.arn;
        this.creationDate = builder.creationDate;
        this.enabled = builder.enabled;
        this.description = builder.description;
        this.keyUsage = builder.keyUsage;
        this.keyState = builder.keyState;
        this.deletionDate = builder.deletionDate;
        this.validTo = builder.validTo;
        this.origin = builder.origin;
        this.customKeyStoreId = builder.customKeyStoreId;
        this.cloudHsmClusterId = builder.cloudHsmClusterId;
        this.expirationModel = builder.expirationModel;
        this.keyManager = builder.keyManager;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    public String keyId() {
        return this.keyId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String description() {
        return this.description;
    }

    public KeyUsageType keyUsage() {
        return KeyUsageType.fromValue(this.keyUsage);
    }

    public String keyUsageAsString() {
        return this.keyUsage;
    }

    public KeyState keyState() {
        return KeyState.fromValue(this.keyState);
    }

    public String keyStateAsString() {
        return this.keyState;
    }

    public Instant deletionDate() {
        return this.deletionDate;
    }

    public Instant validTo() {
        return this.validTo;
    }

    public OriginType origin() {
        return OriginType.fromValue(this.origin);
    }

    public String originAsString() {
        return this.origin;
    }

    public String customKeyStoreId() {
        return this.customKeyStoreId;
    }

    public String cloudHsmClusterId() {
        return this.cloudHsmClusterId;
    }

    public ExpirationModelType expirationModel() {
        return ExpirationModelType.fromValue(this.expirationModel);
    }

    public String expirationModelAsString() {
        return this.expirationModel;
    }

    public KeyManagerType keyManager() {
        return KeyManagerType.fromValue(this.keyManager);
    }

    public String keyManagerAsString() {
        return this.keyManager;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyUsageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.validTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customKeyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudHsmClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyManagerAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyMetadata)) {
            return false;
        }
        KeyMetadata other = (KeyMetadata)obj;
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.keyUsageAsString(), other.keyUsageAsString()) && Objects.equals(this.keyStateAsString(), other.keyStateAsString()) && Objects.equals(this.deletionDate(), other.deletionDate()) && Objects.equals(this.validTo(), other.validTo()) && Objects.equals(this.originAsString(), other.originAsString()) && Objects.equals(this.customKeyStoreId(), other.customKeyStoreId()) && Objects.equals(this.cloudHsmClusterId(), other.cloudHsmClusterId()) && Objects.equals(this.expirationModelAsString(), other.expirationModelAsString()) && Objects.equals(this.keyManagerAsString(), other.keyManagerAsString());
    }

    public String toString() {
        return ToString.builder((String)"KeyMetadata").add("AWSAccountId", (Object)this.awsAccountId()).add("KeyId", (Object)this.keyId()).add("Arn", (Object)this.arn()).add("CreationDate", (Object)this.creationDate()).add("Enabled", (Object)this.enabled()).add("Description", (Object)this.description()).add("KeyUsage", (Object)this.keyUsageAsString()).add("KeyState", (Object)this.keyStateAsString()).add("DeletionDate", (Object)this.deletionDate()).add("ValidTo", (Object)this.validTo()).add("Origin", (Object)this.originAsString()).add("CustomKeyStoreId", (Object)this.customKeyStoreId()).add("CloudHsmClusterId", (Object)this.cloudHsmClusterId()).add("ExpirationModel", (Object)this.expirationModelAsString()).add("KeyManager", (Object)this.keyManagerAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AWSAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "KeyUsage": {
                return Optional.ofNullable(clazz.cast(this.keyUsageAsString()));
            }
            case "KeyState": {
                return Optional.ofNullable(clazz.cast(this.keyStateAsString()));
            }
            case "DeletionDate": {
                return Optional.ofNullable(clazz.cast(this.deletionDate()));
            }
            case "ValidTo": {
                return Optional.ofNullable(clazz.cast(this.validTo()));
            }
            case "Origin": {
                return Optional.ofNullable(clazz.cast(this.originAsString()));
            }
            case "CustomKeyStoreId": {
                return Optional.ofNullable(clazz.cast(this.customKeyStoreId()));
            }
            case "CloudHsmClusterId": {
                return Optional.ofNullable(clazz.cast(this.cloudHsmClusterId()));
            }
            case "ExpirationModel": {
                return Optional.ofNullable(clazz.cast(this.expirationModelAsString()));
            }
            case "KeyManager": {
                return Optional.ofNullable(clazz.cast(this.keyManagerAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyMetadata, T> g) {
        return obj -> g.apply((KeyMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String keyId;
        private String arn;
        private Instant creationDate;
        private Boolean enabled;
        private String description;
        private String keyUsage;
        private String keyState;
        private Instant deletionDate;
        private Instant validTo;
        private String origin;
        private String customKeyStoreId;
        private String cloudHsmClusterId;
        private String expirationModel;
        private String keyManager;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyMetadata model) {
            this.awsAccountId(model.awsAccountId);
            this.keyId(model.keyId);
            this.arn(model.arn);
            this.creationDate(model.creationDate);
            this.enabled(model.enabled);
            this.description(model.description);
            this.keyUsage(model.keyUsage);
            this.keyState(model.keyState);
            this.deletionDate(model.deletionDate);
            this.validTo(model.validTo);
            this.origin(model.origin);
            this.customKeyStoreId(model.customKeyStoreId);
            this.cloudHsmClusterId(model.cloudHsmClusterId);
            this.expirationModel(model.expirationModel);
            this.keyManager(model.keyManager);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKeyUsageAsString() {
            return this.keyUsage;
        }

        @Override
        public final Builder keyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        @Override
        public final Builder keyUsage(KeyUsageType keyUsage) {
            this.keyUsage(keyUsage.toString());
            return this;
        }

        public final void setKeyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
        }

        public final String getKeyStateAsString() {
            return this.keyState;
        }

        @Override
        public final Builder keyState(String keyState) {
            this.keyState = keyState;
            return this;
        }

        @Override
        public final Builder keyState(KeyState keyState) {
            this.keyState(keyState.toString());
            return this;
        }

        public final void setKeyState(String keyState) {
            this.keyState = keyState;
        }

        public final Instant getDeletionDate() {
            return this.deletionDate;
        }

        @Override
        public final Builder deletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
            return this;
        }

        public final void setDeletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
        }

        public final Instant getValidTo() {
            return this.validTo;
        }

        @Override
        public final Builder validTo(Instant validTo) {
            this.validTo = validTo;
            return this;
        }

        public final void setValidTo(Instant validTo) {
            this.validTo = validTo;
        }

        public final String getOriginAsString() {
            return this.origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(OriginType origin) {
            this.origin(origin.toString());
            return this;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        public final String getCustomKeyStoreId() {
            return this.customKeyStoreId;
        }

        @Override
        public final Builder customKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
            return this;
        }

        public final void setCustomKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
        }

        public final String getCloudHsmClusterId() {
            return this.cloudHsmClusterId;
        }

        @Override
        public final Builder cloudHsmClusterId(String cloudHsmClusterId) {
            this.cloudHsmClusterId = cloudHsmClusterId;
            return this;
        }

        public final void setCloudHsmClusterId(String cloudHsmClusterId) {
            this.cloudHsmClusterId = cloudHsmClusterId;
        }

        public final String getExpirationModelAsString() {
            return this.expirationModel;
        }

        @Override
        public final Builder expirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
            return this;
        }

        @Override
        public final Builder expirationModel(ExpirationModelType expirationModel) {
            this.expirationModel(expirationModel.toString());
            return this;
        }

        public final void setExpirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
        }

        public final String getKeyManagerAsString() {
            return this.keyManager;
        }

        @Override
        public final Builder keyManager(String keyManager) {
            this.keyManager = keyManager;
            return this;
        }

        @Override
        public final Builder keyManager(KeyManagerType keyManager) {
            this.keyManager(keyManager.toString());
            return this;
        }

        public final void setKeyManager(String keyManager) {
            this.keyManager = keyManager;
        }

        public KeyMetadata build() {
            return new KeyMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyMetadata> {
        public Builder awsAccountId(String var1);

        public Builder keyId(String var1);

        public Builder arn(String var1);

        public Builder creationDate(Instant var1);

        public Builder enabled(Boolean var1);

        public Builder description(String var1);

        public Builder keyUsage(String var1);

        public Builder keyUsage(KeyUsageType var1);

        public Builder keyState(String var1);

        public Builder keyState(KeyState var1);

        public Builder deletionDate(Instant var1);

        public Builder validTo(Instant var1);

        public Builder origin(String var1);

        public Builder origin(OriginType var1);

        public Builder customKeyStoreId(String var1);

        public Builder cloudHsmClusterId(String var1);

        public Builder expirationModel(String var1);

        public Builder expirationModel(ExpirationModelType var1);

        public Builder keyManager(String var1);

        public Builder keyManager(KeyManagerType var1);
    }
}

